/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.viz;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import edu.stanford.protege.webprotege.entity.OWLEntityData;
import edu.stanford.protege.webprotege.viz.Edge;
import edu.stanford.protege.webprotege.viz.EntityGraph;
import javax.annotation.Nonnull;

final class AutoValue_EntityGraph
extends EntityGraph {
    private final OWLEntityData root;
    private final int nodeCount;
    private final ImmutableSet<OWLEntityData> nodes;
    private final int edgeCount;
    private final ImmutableSet<Edge> edges;
    private final boolean prunedToEdgeLimit;
    private final ImmutableSetMultimap<OWLEntityData, Edge> edgesByTailNode;

    AutoValue_EntityGraph(OWLEntityData root, int nodeCount, ImmutableSet<OWLEntityData> nodes, int edgeCount, ImmutableSet<Edge> edges, boolean prunedToEdgeLimit, ImmutableSetMultimap<OWLEntityData, Edge> edgesByTailNode) {
        if (root == null) {
            throw new NullPointerException("Null root");
        }
        this.root = root;
        this.nodeCount = nodeCount;
        if (nodes == null) {
            throw new NullPointerException("Null nodes");
        }
        this.nodes = nodes;
        this.edgeCount = edgeCount;
        if (edges == null) {
            throw new NullPointerException("Null edges");
        }
        this.edges = edges;
        this.prunedToEdgeLimit = prunedToEdgeLimit;
        if (edgesByTailNode == null) {
            throw new NullPointerException("Null edgesByTailNode");
        }
        this.edgesByTailNode = edgesByTailNode;
    }

    @Override
    @Nonnull
    public OWLEntityData getRoot() {
        return this.root;
    }

    @Override
    @JsonIgnore
    public int getNodeCount() {
        return this.nodeCount;
    }

    @Override
    @JsonIgnore
    @Nonnull
    public ImmutableSet<OWLEntityData> getNodes() {
        return this.nodes;
    }

    @Override
    @JsonIgnore
    public int getEdgeCount() {
        return this.edgeCount;
    }

    @Override
    @Nonnull
    public ImmutableSet<Edge> getEdges() {
        return this.edges;
    }

    @Override
    public boolean isPrunedToEdgeLimit() {
        return this.prunedToEdgeLimit;
    }

    @Override
    @JsonIgnore
    @Nonnull
    public ImmutableSetMultimap<OWLEntityData, Edge> getEdgesByTailNode() {
        return this.edgesByTailNode;
    }

    public String toString() {
        return "EntityGraph{root=" + String.valueOf(this.root) + ", nodeCount=" + this.nodeCount + ", nodes=" + String.valueOf(this.nodes) + ", edgeCount=" + this.edgeCount + ", edges=" + String.valueOf(this.edges) + ", prunedToEdgeLimit=" + this.prunedToEdgeLimit + ", edgesByTailNode=" + String.valueOf(this.edgesByTailNode) + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof EntityGraph) {
            EntityGraph that = (EntityGraph)o;
            return this.root.equals(that.getRoot()) && this.nodeCount == that.getNodeCount() && this.nodes.equals(that.getNodes()) && this.edgeCount == that.getEdgeCount() && this.edges.equals(that.getEdges()) && this.prunedToEdgeLimit == that.isPrunedToEdgeLimit() && this.edgesByTailNode.equals(that.getEdgesByTailNode());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.root.hashCode();
        h$ *= 1000003;
        h$ ^= this.nodeCount;
        h$ *= 1000003;
        h$ ^= this.nodes.hashCode();
        h$ *= 1000003;
        h$ ^= this.edgeCount;
        h$ *= 1000003;
        h$ ^= this.edges.hashCode();
        h$ *= 1000003;
        h$ ^= this.prunedToEdgeLimit ? 1231 : 1237;
        h$ *= 1000003;
        return h$ ^= this.edgesByTailNode.hashCode();
    }
}

