/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.watches;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import edu.stanford.protege.webprotege.common.ProjectId;
import edu.stanford.protege.webprotege.common.UserId;
import edu.stanford.protege.webprotege.watches.WatchType;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLEntity;

public class WatchRecord {
    public static final String PROJECT_ID = "projectId";
    public static final String USER_ID = "userId";
    public static final String ENTITY = "term";
    public static final String TYPE = "type";
    private ProjectId projectId;
    private UserId userId;
    private OWLEntity entity;
    private WatchType type;

    private WatchRecord() {
    }

    public WatchRecord(@Nonnull ProjectId projectId, @Nonnull UserId userId, @Nonnull OWLEntity entity, @Nonnull WatchType type) {
        this.projectId = (ProjectId)Preconditions.checkNotNull((Object)projectId);
        this.userId = (UserId)Preconditions.checkNotNull((Object)userId);
        this.entity = (OWLEntity)Preconditions.checkNotNull((Object)entity);
        this.type = (WatchType)((Object)Preconditions.checkNotNull((Object)((Object)type)));
    }

    @Nonnull
    public ProjectId getProjectId() {
        return this.projectId;
    }

    @Nonnull
    public UserId getUserId() {
        return this.userId;
    }

    @Nonnull
    public OWLEntity getEntity() {
        return this.entity;
    }

    @Nonnull
    public WatchType getType() {
        return this.type;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.projectId, this.userId, this.entity, this.type});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof WatchRecord)) {
            return false;
        }
        WatchRecord other = (WatchRecord)obj;
        return this.projectId.equals((Object)other.projectId) && this.userId.equals((Object)other.userId) && this.entity.equals(other.entity) && this.type == other.type;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"WatchRecord").addValue((Object)this.projectId).addValue((Object)this.userId).addValue((Object)this.entity).addValue((Object)this.type).toString();
    }
}

