/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.change;

import edu.stanford.protege.webprotege.change.AddAxiomChange;
import edu.stanford.protege.webprotege.change.AddImportChange;
import edu.stanford.protege.webprotege.change.AddOntologyAnnotationChange;
import edu.stanford.protege.webprotege.change.OntologyChange;
import edu.stanford.protege.webprotege.change.RemoveAxiomChange;
import edu.stanford.protege.webprotege.change.RemoveImportChange;
import edu.stanford.protege.webprotege.change.RemoveOntologyAnnotationChange;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AddImport;
import org.semanticweb.owlapi.model.AddOntologyAnnotation;
import org.semanticweb.owlapi.model.OWLOntologyChangeVisitorEx;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.model.RemoveImport;
import org.semanticweb.owlapi.model.RemoveOntologyAnnotation;
import org.semanticweb.owlapi.model.SetOntologyID;

public class OwlOntologyChangeTranslatorVisitor
implements OWLOntologyChangeVisitorEx<OntologyChange> {
    @Inject
    public OwlOntologyChangeTranslatorVisitor() {
    }

    @Nonnull
    public OntologyChange visit(@Nonnull AddAxiom change) {
        return AddAxiomChange.of(change.getOntology().getOntologyID(), change.getAxiom());
    }

    @Nonnull
    public OntologyChange visit(@Nonnull RemoveAxiom change) {
        return RemoveAxiomChange.of(change.getOntology().getOntologyID(), change.getAxiom());
    }

    @Nonnull
    public OntologyChange visit(@Nonnull SetOntologyID change) {
        throw new UnsupportedOperationException("SetOntologyID changes are not supported");
    }

    @Nonnull
    public OntologyChange visit(@Nonnull AddImport change) {
        return AddImportChange.of(change.getOntology().getOntologyID(), change.getImportDeclaration());
    }

    @Nonnull
    public OntologyChange visit(@Nonnull RemoveImport change) {
        return RemoveImportChange.of(change.getOntology().getOntologyID(), change.getImportDeclaration());
    }

    @Nonnull
    public OntologyChange visit(@Nonnull AddOntologyAnnotation change) {
        return AddOntologyAnnotationChange.of(change.getOntology().getOntologyID(), change.getAnnotation());
    }

    @Nonnull
    public OntologyChange visit(@Nonnull RemoveOntologyAnnotation change) {
        return RemoveOntologyAnnotationChange.of(change.getOntology().getOntologyID(), change.getAnnotation());
    }
}

