/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.common;

import com.google.common.collect.ImmutableList;
import edu.stanford.protege.webprotege.common.Page;

final class AutoValue_Page<T>
extends Page<T> {
    private final ImmutableList<T> pageElements;
    private final int pageSize;
    private final long totalElements;
    private final int pageNumber;
    private final int pageCount;

    AutoValue_Page(ImmutableList<T> pageElements, int pageSize, long totalElements, int pageNumber, int pageCount) {
        if (pageElements == null) {
            throw new NullPointerException("Null pageElements");
        }
        this.pageElements = pageElements;
        this.pageSize = pageSize;
        this.totalElements = totalElements;
        this.pageNumber = pageNumber;
        this.pageCount = pageCount;
    }

    @Override
    public ImmutableList<T> getPageElements() {
        return this.pageElements;
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public long getTotalElements() {
        return this.totalElements;
    }

    @Override
    public int getPageNumber() {
        return this.pageNumber;
    }

    @Override
    public int getPageCount() {
        return this.pageCount;
    }

    public String toString() {
        return "Page{pageElements=" + this.pageElements + ", pageSize=" + this.pageSize + ", totalElements=" + this.totalElements + ", pageNumber=" + this.pageNumber + ", pageCount=" + this.pageCount + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Page) {
            Page that = (Page)o;
            return this.pageElements.equals(that.getPageElements()) && this.pageSize == that.getPageSize() && this.totalElements == that.getTotalElements() && this.pageNumber == that.getPageNumber() && this.pageCount == that.getPageCount();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.pageElements.hashCode();
        h$ *= 1000003;
        h$ ^= this.pageSize;
        h$ *= 1000003;
        h$ ^= (int)(this.totalElements >>> 32 ^ this.totalElements);
        h$ *= 1000003;
        h$ ^= this.pageNumber;
        h$ *= 1000003;
        return h$ ^= this.pageCount;
    }
}

