/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.common;

import com.fasterxml.jackson.annotation.JsonValue;
import edu.stanford.protege.webprotege.common.DocumentFormatExtension;
import java.util.function.Supplier;
import org.semanticweb.owlapi.formats.FunctionalSyntaxDocumentFormat;
import org.semanticweb.owlapi.formats.ManchesterSyntaxDocumentFormat;
import org.semanticweb.owlapi.formats.OWLXMLDocumentFormat;
import org.semanticweb.owlapi.formats.RDFXMLDocumentFormat;
import org.semanticweb.owlapi.formats.TurtleDocumentFormat;
import org.semanticweb.owlapi.model.OWLDocumentFormat;

public enum DocumentFormat {
    RDF_XML(RDFXMLDocumentFormat::new, "application/rdf+xml", DocumentFormatExtension.owl),
    TURTLE(TurtleDocumentFormat::new, "text/turtle", DocumentFormatExtension.ttl),
    OWL_XML(OWLXMLDocumentFormat::new, "application/owl+xml", DocumentFormatExtension.owx),
    MANCHESTER_SYNTAX(ManchesterSyntaxDocumentFormat::new, "text/owl-manchester", DocumentFormatExtension.omn),
    FUNCTIONAL_SYNTAX(FunctionalSyntaxDocumentFormat::new, "text/owl-functional", DocumentFormatExtension.ofn);

    private final Supplier<OWLDocumentFormat> documentFormatSupplier;
    private final String mimeType;
    private final DocumentFormatExtension extension;

    private DocumentFormat(Supplier<OWLDocumentFormat> documentFormatSupplier, String mimeType, DocumentFormatExtension extension) {
        this.documentFormatSupplier = documentFormatSupplier;
        this.mimeType = mimeType;
        this.extension = extension;
    }

    public String getParameterValue() {
        return this.extension.getExtension();
    }

    public OWLDocumentFormat getDocumentFormat() {
        return this.documentFormatSupplier.get();
    }

    @JsonValue
    public String getMimeType() {
        return this.mimeType;
    }

    public String getExtension() {
        return this.extension.getExtension();
    }

    public static DocumentFormat getDefaultFormat() {
        return RDF_XML;
    }
}

