/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.common;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSetMultimap;
import edu.stanford.protege.webprotege.common.AutoValue_EntityDictionaryLanguageValues;
import edu.stanford.protege.webprotege.common.DictionaryLanguage;
import edu.stanford.protege.webprotege.common.EntityShortForms;
import java.util.Map;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLEntity;

@AutoValue
public abstract class EntityDictionaryLanguageValues {
    public static EntityDictionaryLanguageValues get(@Nonnull OWLEntity entity, @Nonnull ImmutableSetMultimap<DictionaryLanguage, String> values) {
        return new AutoValue_EntityDictionaryLanguageValues(entity, values);
    }

    @Nonnull
    public abstract OWLEntity getEntity();

    @Nonnull
    public abstract ImmutableSetMultimap<DictionaryLanguage, String> getValues();

    @Nonnull
    public EntityShortForms reduceToEntityShortForms() {
        OWLEntity entity = this.getEntity();
        ImmutableMap map = (ImmutableMap)this.getValues().entries().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue, (firstValue, secondValue) -> firstValue));
        return EntityShortForms.get(entity, (ImmutableMap<DictionaryLanguage, String>)map);
    }
}

