/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableMap;
import edu.stanford.protege.webprotege.common.AutoValue_LanguageMap;
import edu.stanford.protege.webprotege.common.LanguageTagFormatter;
import java.util.Map;
import javax.annotation.Nonnull;

@AutoValue
public abstract class LanguageMap {
    private static final LanguageMap EMPTY = LanguageMap.get((Map<String, String>)ImmutableMap.of());

    public static LanguageMap of(String lang, String value) {
        return LanguageMap.get((Map<String, String>)ImmutableMap.of((Object)lang, (Object)value));
    }

    @JsonCreator
    @Nonnull
    public static LanguageMap get(Map<String, String> langMap) {
        return new AutoValue_LanguageMap((ImmutableMap<String, String>)ImmutableMap.copyOf(langMap));
    }

    @JsonIgnore
    public static LanguageMap empty() {
        return EMPTY;
    }

    @JsonIgnore
    @Nonnull
    public static LanguageMapBuilder builder() {
        return new LanguageMapBuilder();
    }

    @Nonnull
    @JsonIgnore
    public String get(@Nonnull String langTag) {
        String normalizedLangTag = LanguageTagFormatter.format(langTag);
        ImmutableMap<String, String> map = this.asMap();
        String val = (String)map.get((Object)normalizedLangTag);
        if (val != null) {
            return val;
        }
        String superLang = normalizedLangTag;
        int lastIndexOfHyphen = superLang.lastIndexOf("-");
        while (lastIndexOfHyphen != -1) {
            String superLangValue = (String)map.get((Object)(superLang = superLang.substring(0, lastIndexOfHyphen)));
            if (superLangValue != null) {
                return superLangValue;
            }
            lastIndexOfHyphen = superLang.lastIndexOf("-");
        }
        return map.values().stream().findFirst().orElse("");
    }

    @JsonValue
    @Nonnull
    public abstract ImmutableMap<String, String> asMap();

    public static class LanguageMapBuilder {
        private final ImmutableMap.Builder<String, String> map = ImmutableMap.builder();

        public LanguageMap build() {
            return LanguageMap.get((Map<String, String>)this.map.build());
        }

        public LanguageMapBuilder put(String lang, String value) {
            String formattedLang = LanguageTagFormatter.format(lang);
            this.map.put((Object)formattedLang, (Object)value);
            return this;
        }
    }
}

