/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.common;

import javax.annotation.Nonnull;

public class LanguageTagFormatter {
    public static String format(@Nonnull String langTag) {
        if (langTag.isEmpty()) {
            return langTag;
        }
        String[] subtags = langTag.split("-");
        StringBuilder sb = new StringBuilder();
        boolean followsSingleton = false;
        for (int i = 0; i < subtags.length; ++i) {
            String subtag = subtags[i];
            if (i == 0) {
                sb.append(subtags[0].toLowerCase());
            } else if (!followsSingleton) {
                if (subtag.length() == 2) {
                    sb.append(subtag.toUpperCase());
                } else if (subtag.length() == 4) {
                    sb.append(Character.toUpperCase(subtag.charAt(0)));
                    sb.append(subtag.substring(1).toLowerCase());
                } else {
                    sb.append(subtag.toLowerCase());
                }
            } else {
                sb.append(subtag.toLowerCase());
            }
            if (sb.length() < langTag.length()) {
                sb.append("-");
            }
            followsSingleton = subtag.length() == 1;
        }
        return sb.toString();
    }
}

