/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import edu.stanford.protege.webprotege.common.AutoValue_Page;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;

@JsonTypeName(value="Page")
@AutoValue
public abstract class Page<T>
implements Serializable,
Iterable<T> {
    public static <T> Page<T> emptyPage() {
        return Page.create(1, 1, ImmutableList.of(), 0L);
    }

    public static <T> Page<T> of(ImmutableList<T> values) {
        return Page.create(1, 1, values, values.size());
    }

    @JsonCreator
    public static <T> Page<T> create(@JsonProperty(value="pageNumber") int pageNumber, @JsonProperty(value="pageCount") int pageCount, @JsonProperty(value="pageElements") List<T> pageElements, @JsonProperty(value="totalElements") long totalElements) {
        Preconditions.checkArgument((pageNumber > 0 ? 1 : 0) != 0, (Object)"pageNumber must be greater than 0");
        Preconditions.checkArgument((pageCount > 0 ? 1 : 0) != 0, (Object)"pageCount must be greater than 0");
        Preconditions.checkArgument((pageNumber <= pageCount ? 1 : 0) != 0);
        Preconditions.checkArgument((totalElements > -1L ? 1 : 0) != 0);
        return new AutoValue_Page(ImmutableList.copyOf(pageElements), pageElements.size(), totalElements, pageNumber, pageCount);
    }

    public abstract ImmutableList<T> getPageElements();

    public abstract int getPageSize();

    public abstract long getTotalElements();

    public abstract int getPageNumber();

    public abstract int getPageCount();

    @Override
    public Iterator<T> iterator() {
        return this.getPageElements().iterator();
    }

    public <E> Page<E> transform(Function<T, E> function) {
        return Page.create(this.getPageNumber(), this.getPageCount(), (List)this.getPageElements().stream().map(function).collect(ImmutableList.toImmutableList()), this.getTotalElements());
    }
}

