/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.common;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.Serializable;

public class PageRequest
implements Serializable {
    public static final int DEFAULT_PAGE_SIZE = 30;
    private static final int FIRST_PAGE = 1;
    public static final int MAX_PAGE_SIZE = Integer.MAX_VALUE;
    private int pageNumber;
    private int pageSize;

    private PageRequest() {
    }

    private PageRequest(int pageNumber) {
        this.pageNumber = pageNumber;
    }

    private PageRequest(int pageNumber, int pageSize) {
        this.pageNumber = pageNumber;
        this.pageSize = pageSize;
    }

    public static PageRequest requestFirstPage() {
        return PageRequest.requestPage(1);
    }

    public static PageRequest requestSinglePage() {
        return PageRequest.requestPageWithSize(1, Integer.MAX_VALUE);
    }

    public static PageRequest requestPage(int pageNumber) {
        return PageRequest.requestPageWithSize(pageNumber, 30);
    }

    public static PageRequest requestPageWithSize(int pageNumber, int pageSize) {
        Preconditions.checkElementIndex((int)(pageNumber - 1), (int)Integer.MAX_VALUE, (String)"pageNumber must be greater than zero");
        Preconditions.checkArgument((pageSize > 0 ? 1 : 0) != 0, (Object)"pageSize must be greater than zero");
        return new PageRequest(pageNumber, pageSize);
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getSkip() {
        return (this.pageNumber - 1) * this.pageSize;
    }

    public int hashCode() {
        return "PageRequest".hashCode() + this.pageNumber + this.pageSize;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageRequest)) {
            return false;
        }
        PageRequest other = (PageRequest)o;
        return this.pageNumber == other.pageNumber && this.pageSize == other.pageSize;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"PageRequest").add("pageNumber", this.pageNumber).add("pageSize", this.pageSize).toString();
    }
}

