/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.common;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public class SearchString {
    private final String rawSearchString;
    private final String searchString;

    private SearchString(@Nonnull String rawSearchString) {
        this.rawSearchString = rawSearchString;
        this.searchString = rawSearchString.startsWith("*") ? rawSearchString.substring(1).toLowerCase() : rawSearchString.toLowerCase();
    }

    @Nonnull
    public static SearchString parseSearchString(@Nonnull String query) {
        return new SearchString(query);
    }

    public static List<SearchString> parseMultiWordSearchString(@Nonnull String query) {
        if (query.isEmpty()) {
            return Collections.emptyList();
        }
        return Stream.of(query.split("\\s+|_|:")).filter(s -> !s.isEmpty()).map(SearchString::parseSearchString).collect(Collectors.toList());
    }

    public String getRawSearchString() {
        return this.rawSearchString;
    }

    public String getSearchString() {
        return this.searchString;
    }

    public int length() {
        return this.searchString.length();
    }

    public boolean isWildCard() {
        return this.rawSearchString.length() > 0 && this.rawSearchString.charAt(0) == '*';
    }

    public boolean matches(@Nonnull String string, int start) {
        return string.startsWith(this.searchString, start);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"SearchString").addValue((Object)this.rawSearchString).toString();
    }
}

