/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import edu.stanford.protege.webprotege.common.ValueObject;
import javax.annotation.Nonnull;

public record UserId(@Nonnull String id) implements ValueObject,
Comparable<UserId>
{
    public static final String GUEST_USERNAME = "guest";

    public boolean isGuest() {
        return this.id.equals(GUEST_USERNAME);
    }

    public static UserId getGuest() {
        return new UserId(GUEST_USERNAME);
    }

    @JsonCreator
    public static UserId valueOf(String id) {
        if (id == null) {
            return UserId.getGuest();
        }
        return new UserId(id);
    }

    @Override
    @JsonIgnore
    public String value() {
        return this.id;
    }

    @Override
    public int compareTo(UserId o) {
        int diff = this.id.compareToIgnoreCase(o.id);
        if (diff != 0) {
            return diff;
        }
        return this.id.compareTo(o.id);
    }
}

