/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.auto.value.AutoValue;
import edu.stanford.protege.webprotege.common.AutoValue_AnnotationAssertionDictionaryLanguage;
import edu.stanford.protege.webprotege.common.DictionaryLanguage;
import edu.stanford.protege.webprotege.common.DictionaryLanguageVisitor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

@JsonTypeName(value="AnnotationAssertion")
@AutoValue
public abstract class AnnotationAssertionDictionaryLanguage
extends DictionaryLanguage {
    public static final String TYPE_NAME = "AnnotationAssertion";
    protected static final String PROPERTY_IRI = "propertyIri";
    protected static final String LANG = "lang";

    @JsonCreator
    public static AnnotationAssertionDictionaryLanguage get(@Nullable @JsonProperty(value="propertyIri") String propertyIri, @Nullable @JsonProperty(value="lang") String lang) {
        String normalisedLang = lang == null ? "" : AnnotationAssertionDictionaryLanguage.lowerCaseLangTag(lang);
        Object iri = OWLRDFVocabulary.RDFS_LABEL.getPrefixedName().equals(propertyIri) ? OWLRDFVocabulary.RDFS_LABEL.getIRI() : (propertyIri != null ? IRI.create((String)propertyIri) : null);
        return new AutoValue_AnnotationAssertionDictionaryLanguage((IRI)iri, normalisedLang);
    }

    @Override
    public boolean isAnnotationBased() {
        return true;
    }

    @Nonnull
    public static AnnotationAssertionDictionaryLanguage get(@Nonnull @JsonProperty(value="propertyIri") IRI propertyIri, @Nullable @JsonProperty(value="lang") String lang) {
        return AnnotationAssertionDictionaryLanguage.get(propertyIri.toString(), lang);
    }

    @Override
    public <R> R accept(@Nonnull DictionaryLanguageVisitor<R> visitor) {
        return visitor.visit(this);
    }

    @JsonIgnore
    @Nonnull
    public abstract IRI getAnnotationPropertyIri();

    @Nullable
    @JsonProperty(value="propertyIri")
    public String getJsonAnnotationPropertyIri() {
        IRI annotationPropertyIri = this.getAnnotationPropertyIri();
        if (OWLRDFVocabulary.RDFS_LABEL.getIRI().equals((Object)annotationPropertyIri)) {
            return OWLRDFVocabulary.RDFS_LABEL.getPrefixedName();
        }
        return annotationPropertyIri.toString();
    }

    @Override
    @JsonProperty(value="lang")
    @Nonnull
    public abstract String getLang();
}

