/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import edu.stanford.protege.webprotege.common.AnnotationAssertionDictionaryLanguage;
import edu.stanford.protege.webprotege.common.AnnotationAssertionPathDictionaryLanguage;
import edu.stanford.protege.webprotege.common.DictionaryLanguageVisitor;
import edu.stanford.protege.webprotege.common.LocalNameDictionaryLanguage;
import edu.stanford.protege.webprotege.common.OboIdDictionaryLanguage;
import edu.stanford.protege.webprotege.common.PrefixedNameDictionaryLanguage;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;
import org.semanticweb.owlapi.vocab.SKOSVocabulary;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type", defaultImpl=DictionaryLanguage.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=AnnotationAssertionDictionaryLanguage.class, name="AnnotationAssertion"), @JsonSubTypes.Type(value=AnnotationAssertionPathDictionaryLanguage.class, name="AnnotationAssertionPath"), @JsonSubTypes.Type(value=LocalNameDictionaryLanguage.class, name="LocalName"), @JsonSubTypes.Type(value=OboIdDictionaryLanguage.class, name="OboId"), @JsonSubTypes.Type(value=PrefixedNameDictionaryLanguage.class, name="PrefixedName")})
public abstract class DictionaryLanguage {
    @JsonCreator
    @Nonnull
    private static DictionaryLanguage createFromJson(@Nullable @JsonProperty(value="propertyIri") String annotationPropertyIri, @Nullable @JsonProperty(value="lang") String lang) {
        if (annotationPropertyIri == null) {
            return LocalNameDictionaryLanguage.get();
        }
        return AnnotationAssertionDictionaryLanguage.get(annotationPropertyIri, lang);
    }

    @Nonnull
    public static DictionaryLanguage rdfsLabel(@Nonnull String lang) {
        return AnnotationAssertionDictionaryLanguage.get(OWLRDFVocabulary.RDFS_LABEL.getIRI(), lang);
    }

    @Nonnull
    public static DictionaryLanguage skosPrefLabel(@Nonnull String lang) {
        return AnnotationAssertionDictionaryLanguage.get(SKOSVocabulary.PREFLABEL.getIRI().toString(), lang);
    }

    @Nonnull
    public static DictionaryLanguage localName() {
        return LocalNameDictionaryLanguage.get();
    }

    @Nonnull
    public static DictionaryLanguage prefixedName() {
        return PrefixedNameDictionaryLanguage.get();
    }

    @Nonnull
    public static DictionaryLanguage oboId() {
        return OboIdDictionaryLanguage.get();
    }

    @JsonIgnore
    public abstract boolean isAnnotationBased();

    public static String lowerCaseLangTag(String langTag) {
        for (int i = 0; i < langTag.length(); ++i) {
            char ch = langTag.charAt(i);
            if (ch >= 'a' && ch <= 'z' || ch == '-') continue;
            return langTag.toLowerCase();
        }
        return langTag;
    }

    public abstract <R> R accept(@Nonnull DictionaryLanguageVisitor<R> var1);

    @Nonnull
    public abstract String getLang();
}

