/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import edu.stanford.protege.webprotege.common.AnnotationAssertionDictionaryLanguage;
import edu.stanford.protege.webprotege.common.AutoValue_DictionaryLanguageData;
import edu.stanford.protege.webprotege.common.DictionaryLanguage;
import edu.stanford.protege.webprotege.common.LocalNameDictionaryLanguage;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@AutoValue
public abstract class DictionaryLanguageData {
    private static final String PROPERTY_IRI = "propertyIri";
    private static final String LANGUAGE_TAG = "lang";
    private DictionaryLanguage dictionaryLanguage = null;

    @Nonnull
    public static DictionaryLanguageData get(@Nullable IRI propertyIri, @Nonnull String browserText, @Nullable String lang) {
        String normalisedLang = lang == null ? "" : lang.toLowerCase();
        return new AutoValue_DictionaryLanguageData(propertyIri, browserText, normalisedLang);
    }

    @JsonCreator
    @Nonnull
    public static DictionaryLanguageData get(@Nullable @JsonProperty(value="propertyIri") IRI propertyIri, @Nonnull @JsonProperty(value="lang") String languageTag) {
        return DictionaryLanguageData.get(propertyIri, DictionaryLanguageData.getBrowserText(propertyIri), languageTag);
    }

    public static DictionaryLanguageData localName() {
        return DictionaryLanguageData.get(null, "");
    }

    public static DictionaryLanguageData rdfsLabel(@Nonnull String languageTag) {
        return DictionaryLanguageData.get(OWLRDFVocabulary.RDFS_LABEL.getIRI(), languageTag);
    }

    private static String getBrowserText(@Nullable IRI propertyIri) {
        return propertyIri.toString();
    }

    @Nonnull
    public static DictionaryLanguageData getRdfsLabelWithLang(@Nonnull String lang) {
        return DictionaryLanguageData.get(OWLRDFVocabulary.RDFS_LABEL.getIRI(), OWLRDFVocabulary.RDFS_LABEL.getPrefixedName(), lang);
    }

    @JsonProperty(value="propertyIri")
    @Nullable
    public abstract IRI getAnnotationPropertyIri();

    @JsonIgnore
    @Nonnull
    public abstract String getAnnotationPropertyBrowserText();

    @JsonProperty(value="lang")
    @Nonnull
    public abstract String getLanguageTag();

    @JsonIgnore
    @Nonnull
    public DictionaryLanguage getDictionaryLanguage() {
        if (this.dictionaryLanguage == null) {
            this.dictionaryLanguage = this.createDictionaryLanguage();
        }
        return this.dictionaryLanguage;
    }

    private DictionaryLanguage createDictionaryLanguage() {
        IRI propertyIri = this.getAnnotationPropertyIri();
        if (propertyIri == null) {
            return LocalNameDictionaryLanguage.get();
        }
        return AnnotationAssertionDictionaryLanguage.get(propertyIri, this.getLanguageTag());
    }

    @JsonIgnore
    public boolean isAnnotationBased() {
        return this.getAnnotationPropertyIri() != null;
    }
}

