/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.common;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import edu.stanford.protege.webprotege.common.AutoValue_EntityShortFormMatches;
import edu.stanford.protege.webprotege.common.ShortFormMatch;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLEntity;

@AutoValue
public abstract class EntityShortFormMatches {
    public static EntityShortFormMatches get(@Nonnull OWLEntity entity, @Nonnull ImmutableList<ShortFormMatch> shortFormMatches) {
        EntityShortFormMatches.checkShortFormMatchEntities(entity, shortFormMatches);
        return new AutoValue_EntityShortFormMatches(entity, shortFormMatches);
    }

    private static void checkShortFormMatchEntities(@Nonnull OWLEntity entity, @Nonnull ImmutableList<ShortFormMatch> shortFormMatches) {
        for (ShortFormMatch shortFormMatch : shortFormMatches) {
            if (shortFormMatch.getEntity().equals(entity)) continue;
            throw new IllegalArgumentException(String.format("Short form term (%s) does not match main term (%s)", shortFormMatch.getEntity(), entity));
        }
    }

    @Nonnull
    public abstract OWLEntity getEntity();

    @Nonnull
    public abstract ImmutableList<ShortFormMatch> getShortFormMatches();
}

