/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableSet;
import edu.stanford.protege.webprotege.common.AutoValue_LangTagFilter;
import edu.stanford.protege.webprotege.common.LangTag;
import javax.annotation.Nonnull;

@AutoValue
public abstract class LangTagFilter {
    public static final String FILTERED_LANG_TAGS = "filteredLangTags";

    @JsonCreator
    @Nonnull
    public static LangTagFilter get(@JsonProperty(value="filteredLangTags") @Nonnull ImmutableSet<LangTag> filteredLangTags) {
        return new AutoValue_LangTagFilter(filteredLangTags);
    }

    @Nonnull
    @JsonProperty(value="filteredLangTags")
    public abstract ImmutableSet<LangTag> getFilteringTags();

    public boolean isAnyLangTagIncluded() {
        return this.getFilteringTags().isEmpty();
    }

    public boolean isFilterActive() {
        return this.getFilteringTags().size() > 0;
    }

    public boolean isIncluded(@Nonnull LangTag langTag) {
        ImmutableSet<LangTag> filteringTags = this.getFilteringTags();
        return filteringTags.isEmpty() || filteringTags.contains((Object)langTag);
    }

    public boolean isIncluded(@Nonnull String langTag) {
        if (this.getFilteringTags().isEmpty()) {
            return true;
        }
        LangTag tag = LangTag.get(langTag);
        return this.isIncluded(tag);
    }
}

