/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.common;

import edu.stanford.protege.webprotege.common.Page;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;

public class PageCollector<T>
implements Collector<T, List<T>, Optional<Page<T>>> {
    public static final int DEFAULT_PAGE_SIZE = 30;
    private int counter = 0;
    private final int pageSize;
    private final int pageNumber;

    private PageCollector(int pageSize, int pageNumber) {
        this.pageSize = pageSize;
        this.pageNumber = pageNumber;
    }

    @Override
    public Supplier<List<T>> supplier() {
        return ArrayList::new;
    }

    @Override
    public BiConsumer<List<T>, T> accumulator() {
        return (ts, t) -> {
            int currentPage = this.counter / this.pageSize + 1;
            if (currentPage == this.pageNumber) {
                ts.add(t);
            }
            ++this.counter;
        };
    }

    @Override
    public BinaryOperator<List<T>> combiner() {
        return (ts, ts2) -> {
            ts.addAll(ts2);
            return ts;
        };
    }

    @Override
    public Function<List<T>, Optional<Page<T>>> finisher() {
        return ts -> {
            int elementCount = this.counter;
            int fullPages = elementCount / this.pageSize;
            int remainder = elementCount % this.pageSize;
            int pageCount = fullPages + (remainder == 0 ? 0 : 1);
            if (this.pageNumber > pageCount) {
                return Optional.empty();
            }
            Page page = Page.create(this.pageNumber, pageCount, ts, elementCount);
            return Optional.of(page);
        };
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return Collections.emptySet();
    }

    public static <T> PageCollector<T> toPage(int pageNumber, int pageSize) {
        return PageCollector.toPageNumber(pageNumber).forPageSize(pageSize);
    }

    public static <T> PageCollectorBuilder<T> toPageNumber(int pageNumber) {
        if (pageNumber < 1) {
            throw new IllegalArgumentException("Page number must be greater than zero");
        }
        return new PageCollectorBuilder(pageNumber);
    }

    public static final class PageCollectorBuilder<T> {
        private final int pageNumber;

        public PageCollectorBuilder(int pageNumber) {
            this.pageNumber = pageNumber;
        }

        public <S> PageCollector<S> forPageSize(int pageSize) {
            if (pageSize < 1) {
                throw new IllegalArgumentException("Page size must be greater than zero");
            }
            return new PageCollector(pageSize, this.pageNumber);
        }

        public <S> PageCollector<S> withDefaultPageSize() {
            return new PageCollector(30, this.pageNumber);
        }
    }
}

