/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.common;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import edu.stanford.protege.webprotege.common.Page;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;

public class Pager<T>
implements Serializable {
    private List<List<T>> partition;
    private int sourceDataSize;

    private Pager() {
    }

    private Pager(List<T> sourceData) {
        this(sourceData, 30);
    }

    private Pager(List<T> sourceData, int pageSize) {
        Preconditions.checkArgument((pageSize > 0 ? 1 : 0) != 0);
        this.sourceDataSize = sourceData.size();
        this.partition = Lists.partition(sourceData, (int)pageSize);
    }

    public static <T> Pager<T> getPagerForPageSize(List<T> sourceData, int pageSize) {
        return new Pager<T>(sourceData, pageSize);
    }

    public int getPageCount() {
        if (this.partition.isEmpty()) {
            return 1;
        }
        return this.partition.size();
    }

    public Page<T> getPage(int pageNumber) {
        Preconditions.checkElementIndex((int)(pageNumber - 1), (int)this.getPageCount());
        if (this.partition.isEmpty()) {
            return Page.create(pageNumber, this.getPageCount(), Collections.emptyList(), 0L);
        }
        return Page.create(pageNumber, this.getPageCount(), this.partition.get(pageNumber - 1), this.sourceDataSize);
    }
}

