/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import edu.stanford.protege.webprotege.common.ValueObject;
import java.io.Serializable;
import java.util.UUID;
import javax.annotation.Nonnull;

public record ProjectId(@Nonnull String id) implements ValueObject,
Serializable
{
    @JsonCreator
    @Nonnull
    public static ProjectId valueOf(String id) {
        return new ProjectId(UUID.fromString(id).toString());
    }

    @Nonnull
    public static ProjectId generate() {
        return ProjectId.valueOf(UUID.randomUUID().toString());
    }

    public static ProjectId getNil() {
        return ProjectId.valueOf("00000000-0000-0000-0000-000000000000");
    }

    @Override
    public String value() {
        return this.id;
    }
}

