/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.common;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import edu.stanford.protege.webprotege.common.AutoValue_ShortFormMatch;
import edu.stanford.protege.webprotege.common.DictionaryLanguage;
import edu.stanford.protege.webprotege.common.ShortFormMatchPosition;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLEntity;

@AutoValue
public abstract class ShortFormMatch {
    @Nonnull
    public static ShortFormMatch get(@Nonnull OWLEntity entity, @Nonnull String shortForm, @Nonnull DictionaryLanguage language, @Nonnull ImmutableList<ShortFormMatchPosition> shortFormMatchPositions) {
        for (ShortFormMatchPosition shortFormMatchPosition : shortFormMatchPositions) {
            if (shortFormMatchPosition.getStart() >= shortForm.length()) {
                throw new IllegalArgumentException("Short form match start must be less than short from length");
            }
            if (shortFormMatchPosition.getEnd() <= shortForm.length()) continue;
            throw new IllegalArgumentException("Short form match end must be less than or equal to the short from length");
        }
        return new AutoValue_ShortFormMatch(entity, shortForm, shortFormMatchPositions, language);
    }

    @Nonnull
    public abstract OWLEntity getEntity();

    @Nonnull
    public abstract String getShortForm();

    @Nonnull
    public abstract ImmutableList<ShortFormMatchPosition> getMatchPositions();

    @Nonnull
    public abstract DictionaryLanguage getLanguage();
}

