/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.entity;

import com.google.common.base.Preconditions;

public enum EntityNameCharType {
    UPPER_CASE_LETTER(LetterCategory.WORD),
    LETTER(LetterCategory.WORD),
    DIGIT(LetterCategory.WORD),
    BOUNDARY(LetterCategory.NON_WORD),
    ESCAPING_QUOTE(LetterCategory.NON_WORD);

    private static final char SINGLE_QUOTE = '\'';
    private final LetterCategory letterCategory;

    private EntityNameCharType(LetterCategory letterCategory) {
        this.letterCategory = letterCategory;
    }

    public boolean isWordLetter() {
        return this.letterCategory == LetterCategory.WORD;
    }

    public static EntityNameCharType getType(String text, int index) {
        Preconditions.checkNotNull((Object)text);
        Preconditions.checkElementIndex((int)index, (int)text.length());
        char ch = text.charAt(index);
        return EntityNameCharType.getType(index, ch, text.length());
    }

    public static EntityNameCharType getType(int index, char ch, int length) {
        if (Character.isUpperCase(ch)) {
            return UPPER_CASE_LETTER;
        }
        if (Character.isLowerCase(ch)) {
            return LETTER;
        }
        if (Character.isDigit(ch)) {
            return DIGIT;
        }
        if (index == 0 && ch == '\'') {
            return ESCAPING_QUOTE;
        }
        if (index == length - 1 && ch == '\'') {
            return ESCAPING_QUOTE;
        }
        if (ch == '-') {
            return LETTER;
        }
        if (ch == '\'') {
            return LETTER;
        }
        if (ch == ' ') {
            return BOUNDARY;
        }
        if ('!' <= ch && ch <= '/') {
            return BOUNDARY;
        }
        if (':' <= ch && ch <= '@') {
            return BOUNDARY;
        }
        if ('[' <= ch && ch <= '`') {
            return BOUNDARY;
        }
        if ('{' <= ch && ch <= '~') {
            return BOUNDARY;
        }
        if (ch == '\t') {
            return BOUNDARY;
        }
        if (ch == '\n') {
            return BOUNDARY;
        }
        return LETTER;
    }

    static enum LetterCategory {
        WORD,
        NON_WORD;

    }
}

