/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import edu.stanford.protege.webprotege.common.DictionaryLanguage;
import edu.stanford.protege.webprotege.common.ShortForm;
import edu.stanford.protege.webprotege.entity.AutoValue_OWLAnnotationPropertyData;
import edu.stanford.protege.webprotege.entity.OWLEntityDataVisitorEx;
import edu.stanford.protege.webprotege.entity.OWLPrimitiveDataVisitor;
import edu.stanford.protege.webprotege.entity.OWLPropertyData;
import edu.stanford.protege.webprotege.entity.PrimitiveType;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLEntityVisitorEx;
import uk.ac.manchester.cs.owl.owlapi.OWLAnnotationPropertyImpl;

@JsonTypeName(value="AnnotationPropertyData")
@AutoValue
public abstract class OWLAnnotationPropertyData
extends OWLPropertyData {
    public static final int BEFORE = -1;

    public static OWLAnnotationPropertyData get(@Nonnull OWLAnnotationProperty property, @Nonnull ImmutableMap<DictionaryLanguage, String> shortForms) {
        return OWLAnnotationPropertyData.get(property, shortForms, false);
    }

    public static OWLAnnotationPropertyData get(@Nonnull OWLAnnotationProperty property, @Nonnull ImmutableMap<DictionaryLanguage, String> shortForms, boolean deprecated) {
        return OWLAnnotationPropertyData.get(property, OWLAnnotationPropertyData.toShortFormList(shortForms), deprecated);
    }

    public static OWLAnnotationPropertyData get(OWLAnnotationProperty property, ImmutableList<ShortForm> shortForms, boolean deprecated) {
        return new AutoValue_OWLAnnotationPropertyData(shortForms, deprecated, property);
    }

    @JsonCreator
    private static OWLAnnotationPropertyData get(@JsonProperty(value="iri") String iri, @JsonProperty(value="shortForms", defaultValue="[]") ImmutableList<ShortForm> shortForms, @JsonProperty(value="deprecated", defaultValue="false") boolean deprecated) {
        return new AutoValue_OWLAnnotationPropertyData((ImmutableList<ShortForm>)Objects.requireNonNullElse(shortForms, ImmutableList.of()), deprecated, (OWLAnnotationProperty)new OWLAnnotationPropertyImpl(IRI.create((String)iri)));
    }

    @Nonnull
    public abstract OWLAnnotationProperty getObject();

    @JsonIgnore
    public OWLAnnotationProperty getEntity() {
        return this.getObject();
    }

    @JsonProperty(value="iri")
    private String getIri() {
        return this.getEntity().getIRI().toString();
    }

    @Override
    public <R, E extends Throwable> R accept(OWLPrimitiveDataVisitor<R, E> visitor) throws E {
        return visitor.visit(this);
    }

    @Override
    public <R> R accept(OWLEntityVisitorEx<R> visitor, R defaultValue) {
        return (R)visitor.visit(this.getObject());
    }

    @Override
    public boolean isOWLAnnotationProperty() {
        return true;
    }

    @Override
    public PrimitiveType getType() {
        return PrimitiveType.ANNOTATION_PROPERTY;
    }

    @Override
    public <R> R accept(OWLEntityDataVisitorEx<R> visitor) {
        return visitor.visit(this);
    }
}

