/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import edu.stanford.protege.webprotege.common.DictionaryLanguage;
import edu.stanford.protege.webprotege.common.ShortForm;
import edu.stanford.protege.webprotege.entity.AutoValue_OWLClassData;
import edu.stanford.protege.webprotege.entity.OWLEntityData;
import edu.stanford.protege.webprotege.entity.OWLEntityDataVisitorEx;
import edu.stanford.protege.webprotege.entity.OWLPrimitiveDataVisitor;
import edu.stanford.protege.webprotege.entity.PrimitiveType;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLEntityVisitorEx;
import uk.ac.manchester.cs.owl.owlapi.OWLClassImpl;

@JsonTypeName(value="ClassData")
@AutoValue
public abstract class OWLClassData
extends OWLEntityData {
    public static OWLClassData get(@Nonnull OWLClass cls, @Nonnull ImmutableMap<DictionaryLanguage, String> shortForms) {
        return OWLClassData.get(cls, shortForms, false);
    }

    public static OWLClassData get(@Nonnull OWLClass cls, @Nonnull ImmutableMap<DictionaryLanguage, String> shortForms, boolean deprecated) {
        return OWLClassData.get(cls, OWLClassData.toShortFormList(shortForms), deprecated);
    }

    public static OWLClassData get(@JsonProperty(value="entity") @Nonnull OWLClass cls, @JsonProperty(value="shortForms") @Nonnull ImmutableList<ShortForm> shortForms, @JsonProperty(value="deprecated") boolean deprecated) {
        return new AutoValue_OWLClassData(shortForms, deprecated, cls);
    }

    @JsonCreator
    protected static OWLClassData get(@JsonProperty(value="iri") @Nonnull String iri, @JsonProperty(value="shortForms") @Nullable ImmutableList<ShortForm> shortForms, @JsonProperty(value="deprecated") boolean deprecated) {
        return new AutoValue_OWLClassData((ImmutableList<ShortForm>)Objects.requireNonNullElse(shortForms, ImmutableList.of()), deprecated, (OWLClass)new OWLClassImpl(IRI.create((String)iri)));
    }

    @JsonIgnore
    public OWLClass getEntity() {
        return this.getObject();
    }

    @JsonProperty(value="iri")
    protected String getIri() {
        return this.getEntity().getIRI().toString();
    }

    @Nonnull
    public abstract OWLClass getObject();

    @Override
    @JsonIgnore
    public PrimitiveType getType() {
        return PrimitiveType.CLASS;
    }

    @Override
    public <R, E extends Throwable> R accept(OWLPrimitiveDataVisitor<R, E> visitor) throws E {
        return visitor.visit(this);
    }

    @Override
    public <R> R accept(OWLEntityVisitorEx<R> visitor, R defaultValue) {
        return (R)visitor.visit(this.getEntity());
    }

    @Override
    public <R> R accept(OWLEntityDataVisitorEx<R> visitor) {
        return visitor.visit(this);
    }
}

