/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import edu.stanford.protege.webprotege.entity.FreshEntityIri;
import edu.stanford.protege.webprotege.entity.OWLAnnotationPropertyData;
import edu.stanford.protege.webprotege.entity.OWLClassData;
import edu.stanford.protege.webprotege.entity.OWLDataPropertyData;
import edu.stanford.protege.webprotege.entity.OWLDatatypeData;
import edu.stanford.protege.webprotege.entity.OWLEntityDataVisitorEx;
import edu.stanford.protege.webprotege.entity.OWLNamedIndividualData;
import edu.stanford.protege.webprotege.entity.OWLObjectPropertyData;
import edu.stanford.protege.webprotege.entity.OWLPrimitiveData;
import java.util.Optional;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLEntity;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME)
@JsonSubTypes(value={@JsonSubTypes.Type(value=OWLClassData.class), @JsonSubTypes.Type(value=OWLObjectPropertyData.class), @JsonSubTypes.Type(value=OWLDataPropertyData.class), @JsonSubTypes.Type(value=OWLAnnotationPropertyData.class), @JsonSubTypes.Type(value=OWLNamedIndividualData.class), @JsonSubTypes.Type(value=OWLDatatypeData.class)})
public abstract class OWLEntityData
extends OWLPrimitiveData {
    public OWLEntity getEntity() {
        return (OWLEntity)this.getObject();
    }

    @JsonIgnore
    public boolean isIRIEmpty() {
        return this.getEntity().getIRI().length() == 0;
    }

    public int compareToIgnorePrefixNames(OWLEntityData other) {
        int prefixSepIndex = this.getPrefixSeparatorIndex();
        String comparisonString = this.getBrowserText().substring(prefixSepIndex != -1 ? prefixSepIndex : 0);
        int otherPrefixSepIndex = other.getPrefixSeparatorIndex();
        String otherComparisonString = other.getBrowserText().substring(otherPrefixSepIndex != -1 ? otherPrefixSepIndex : 0);
        return comparisonString.compareToIgnoreCase(otherComparisonString);
    }

    public abstract <R> R accept(OWLEntityDataVisitorEx<R> var1);

    @Override
    public String getBrowserText() {
        IRI iri = this.getEntity().getIRI();
        if (FreshEntityIri.isFreshEntityIri(iri)) {
            return FreshEntityIri.parse(iri.toString()).getSuppliedName();
        }
        return this.getFirstShortForm(() -> ((IRI)iri).toQuotedString());
    }

    public int compareToIgnoreCase(OWLEntityData other) {
        return this.getBrowserText().compareToIgnoreCase(other.getBrowserText());
    }

    @JsonIgnore
    public int getPrefixSeparatorIndex() {
        return this.getBrowserText().indexOf(58);
    }

    @JsonIgnore
    public String getUnquotedBrowserText() {
        String browserText = this.getBrowserText();
        if (browserText.startsWith("'") && browserText.endsWith("'")) {
            return browserText.substring(1, browserText.length() - 1);
        }
        return browserText;
    }

    @Override
    public Optional<OWLAnnotationValue> asAnnotationValue() {
        return Optional.of(this.getEntity().getIRI());
    }

    @Override
    public Optional<OWLEntity> asEntity() {
        return Optional.of(this.getEntity());
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public abstract boolean isDeprecated();
}

