/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.entity;

import com.google.common.base.Preconditions;
import edu.stanford.protege.webprotege.common.UserId;
import edu.stanford.protege.webprotege.entity.OWLEntityData;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;

public class CommentedEntityData
implements Comparable<CommentedEntityData> {
    public static final transient Comparator<CommentedEntityData> byEntity = Comparator.naturalOrder();
    public static final transient Comparator<CommentedEntityData> byLastModified = Comparator.comparing(CommentedEntityData::getLastModified, Comparator.reverseOrder()).thenComparing(Comparator.naturalOrder());
    private OWLEntityData entityData;
    private int totalThreadCount;
    private int openThreadCount;
    private int totalCommentCount;
    private long lastModified;
    private UserId lastModifiedBy;
    private List<UserId> partipants;
    private static final transient Comparator<CommentedEntityData> comparator = Comparator.comparing(c -> c.getOpenThreadCount() > 0).reversed().thenComparing(c -> c.getEntityData().getBrowserText().toLowerCase());

    private CommentedEntityData() {
    }

    public CommentedEntityData(@Nonnull OWLEntityData entityData, int totalThreadCount, int openThreadCount, int totalCommentCount, long lastModified, @Nonnull UserId lastModifiedBy, @Nonnull List<UserId> participants) {
        this.entityData = (OWLEntityData)Preconditions.checkNotNull((Object)entityData);
        this.totalThreadCount = totalThreadCount;
        this.openThreadCount = openThreadCount;
        this.totalCommentCount = totalCommentCount;
        this.lastModified = lastModified;
        this.lastModifiedBy = (UserId)Preconditions.checkNotNull((Object)lastModifiedBy);
        this.partipants = new ArrayList<UserId>(participants);
    }

    @Nonnull
    public OWLEntityData getEntityData() {
        return this.entityData;
    }

    public int getTotalThreadCount() {
        return this.totalThreadCount;
    }

    public int getOpenThreadCount() {
        return this.openThreadCount;
    }

    public int getTotalCommentCount() {
        return this.totalCommentCount;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    @Nonnull
    public UserId getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    public List<UserId> getPartipants() {
        return new ArrayList<UserId>(this.partipants);
    }

    @Override
    public int compareTo(@Nonnull CommentedEntityData o) {
        return comparator.compare(this, o);
    }
}

