/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import edu.stanford.protege.webprotege.entity.AutoValue_FreshEntityIri;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.EntityType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityProvider;

@AutoValue
public abstract class FreshEntityIri {
    private static final String QUERY_SEPARATOR = "?";
    private static final String QUERY_PARAM_SEPARATOR = "&";
    private static final String FRAGMENT_IDENTIFIER = "#";
    private static final String PARAM_SEPARATOR = "&";
    public static final String AMPERSAND_ESCAPE = "%26";
    public static final String HASH_ESCAPE = "%23";
    public static final String DISCRIMINATOR_PARAM_NAME = "discriminator";
    public static final String LANG_TAG_PARAM_NAME = "langTag";
    public static final String PARENT_IRI_PARAM_NAME = "parentIri";
    public static final String SCHEME = "term";

    @JsonCreator
    @Nonnull
    public static FreshEntityIri get(@JsonProperty(value="suppliedName") @Nonnull String suppliedName, @JsonProperty(value="langTag") @Nonnull String langTag, @JsonProperty(value="discriminator") @Nonnull String discriminator, @JsonProperty(value="parentIris") @Nonnull ImmutableSet<IRI> parentIris) {
        return new AutoValue_FreshEntityIri(suppliedName, langTag, discriminator, parentIris);
    }

    public IRI getIri() {
        String schemeAndTypeName = "term:";
        String langTagParam = "langTag=" + this.getLangTag();
        String discriminatorParam = "discriminator=" + this.getDiscriminator();
        String parentIriParams = this.getParentIris().stream().map(IRI::toString).map(iri -> iri.replace("&", AMPERSAND_ESCAPE)).map(iri -> iri.replace(FRAGMENT_IDENTIFIER, HASH_ESCAPE)).map(param -> "&parentIri=" + param).collect(Collectors.joining(""));
        String queryParams = QUERY_SEPARATOR + langTagParam + "&" + discriminatorParam + parentIriParams;
        String fragment = FRAGMENT_IDENTIFIER + this.getSuppliedName();
        String iri2 = schemeAndTypeName + queryParams + fragment;
        return IRI.create((String)iri2);
    }

    @Nonnull
    public abstract String getSuppliedName();

    @Nonnull
    public abstract String getLangTag();

    @Nonnull
    public abstract String getDiscriminator();

    @Nonnull
    public abstract ImmutableSet<IRI> getParentIris();

    @Nonnull
    public ImmutableList<OWLEntity> getParentEntities(@Nonnull OWLEntityProvider dataFactory, @Nonnull EntityType<?> forEntityType) {
        return (ImmutableList)this.getParentIris().stream().map(iri -> {
            if (forEntityType.equals(EntityType.CLASS) || forEntityType.equals(EntityType.NAMED_INDIVIDUAL)) {
                return dataFactory.getOWLClass(iri);
            }
            if (forEntityType.equals(EntityType.OBJECT_PROPERTY)) {
                return dataFactory.getOWLObjectProperty(iri);
            }
            if (forEntityType.equals(EntityType.DATA_PROPERTY)) {
                return dataFactory.getOWLDataProperty(iri);
            }
            if (forEntityType.equals(EntityType.ANNOTATION_PROPERTY)) {
                return dataFactory.getOWLAnnotationProperty(iri);
            }
            return null;
        }).filter(Objects::nonNull).map(e -> e).collect(ImmutableList.toImmutableList());
    }

    public static boolean isFreshEntityIri(@Nonnull IRI iri) {
        Preconditions.checkNotNull((Object)iri);
        return Objects.equals(iri.getScheme(), SCHEME);
    }

    @Nonnull
    public static FreshEntityIri parse(@Nonnull String iriString) {
        int colonIndex = iriString.indexOf(":");
        if (colonIndex == -1) {
            throw new RuntimeException("Missing colon");
        }
        int querySeparatorIndex = iriString.indexOf(QUERY_SEPARATOR);
        if (querySeparatorIndex == -1) {
            throw new RuntimeException("Missing query separator (?)");
        }
        int fragmentIdentifierIndex = iriString.indexOf(FRAGMENT_IDENTIFIER);
        if (fragmentIdentifierIndex == -1) {
            throw new RuntimeException("Missing fragment identifier (#)");
        }
        if (colonIndex >= querySeparatorIndex && querySeparatorIndex >= fragmentIdentifierIndex) {
            throw new RuntimeException("Malformed fresh term IRI");
        }
        String queryToken = iriString.substring(querySeparatorIndex + 1, fragmentIdentifierIndex);
        String discriminator = "";
        String langTag = "";
        ImmutableSet.Builder parentIris = ImmutableSet.builder();
        for (String keyValue : Splitter.on((String)"&").trimResults().split((CharSequence)queryToken)) {
            List keyValueList = Splitter.on((String)"=").splitToList((CharSequence)keyValue);
            String key = (String)keyValueList.get(0);
            String value = (String)keyValueList.get(1);
            if (key.equals(DISCRIMINATOR_PARAM_NAME) && discriminator.isEmpty()) {
                discriminator = value;
                continue;
            }
            if (key.equals(LANG_TAG_PARAM_NAME) && langTag.isEmpty()) {
                langTag = value;
                continue;
            }
            if (!key.equals(PARENT_IRI_PARAM_NAME)) continue;
            parentIris.add((Object)IRI.create((String)value.replace(AMPERSAND_ESCAPE, "&").replace(HASH_ESCAPE, FRAGMENT_IDENTIFIER)));
        }
        String suppliedName = iriString.substring(fragmentIdentifierIndex + 1);
        return FreshEntityIri.get(suppliedName, langTag, discriminator, (ImmutableSet<IRI>)parentIris.build());
    }
}

