/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import edu.stanford.protege.webprotege.common.DictionaryLanguage;
import edu.stanford.protege.webprotege.common.ShortForm;
import edu.stanford.protege.webprotege.entity.AutoValue_IRIData;
import edu.stanford.protege.webprotege.entity.OWLPrimitiveData;
import edu.stanford.protege.webprotege.entity.OWLPrimitiveDataVisitor;
import edu.stanford.protege.webprotege.entity.PrimitiveType;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitorEx;

@JsonTypeName(value="IRIData")
@AutoValue
public abstract class IRIData
extends OWLPrimitiveData {
    public static IRIData get(@Nonnull IRI iri, @Nonnull ImmutableMap<DictionaryLanguage, String> shortForms) {
        return IRIData.get(iri, IRIData.toShortFormList(shortForms));
    }

    public static IRIData get(IRI iri, ImmutableList<ShortForm> shortForms) {
        return new AutoValue_IRIData(shortForms, false, iri);
    }

    public static IRIData get(IRI iri, ImmutableList<ShortForm> shortForms, boolean deprecated) {
        return new AutoValue_IRIData(shortForms, deprecated, iri);
    }

    @JsonCreator
    private static IRIData get(@JsonProperty(value="iri") String iri, @JsonProperty(value="shortForms", defaultValue="[]") ImmutableList<ShortForm> shortForms, @JsonProperty(value="deprecated", defaultValue="false") boolean deprecated) {
        return new AutoValue_IRIData((ImmutableList<ShortForm>)Objects.requireNonNullElse(shortForms, ImmutableList.of()), deprecated, IRI.create((String)iri));
    }

    @Nonnull
    public abstract IRI getObject();

    @JsonIgnore
    public IRI getIri() {
        return this.getObject();
    }

    @JsonProperty(value="iri")
    private String getIriString() {
        return this.getIri().toString();
    }

    @Override
    public PrimitiveType getType() {
        return PrimitiveType.IRI;
    }

    @Override
    public <R, E extends Throwable> R accept(OWLPrimitiveDataVisitor<R, E> visitor) throws E {
        return visitor.visit(this);
    }

    @Override
    public <R> R accept(OWLEntityVisitorEx<R> visitor, R defaultValue) {
        return defaultValue;
    }

    @Override
    public String getBrowserText() {
        return this.getObject().toString();
    }

    @JsonIgnore
    public boolean isHTTPLink() {
        return "http".equalsIgnoreCase(this.getObject().getScheme()) || "https".equalsIgnoreCase(this.getObject().getScheme());
    }

    @JsonIgnore
    public boolean isWikipediaLink() {
        return this.isHTTPLink() && this.getObject().toString().contains("wikipedia.org/wiki/");
    }

    @JsonIgnore
    public String getUnquotedBrowserText() {
        return this.getObject().toString();
    }

    @Override
    public Optional<OWLAnnotationValue> asAnnotationValue() {
        return Optional.of(this.getObject());
    }

    @Override
    public Optional<OWLEntity> asEntity() {
        return Optional.empty();
    }

    @Override
    public Optional<IRI> asIRI() {
        return Optional.of(this.getObject());
    }
}

