/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import edu.stanford.protege.webprotege.common.DictionaryLanguage;
import edu.stanford.protege.webprotege.common.ShortForm;
import edu.stanford.protege.webprotege.entity.AutoValue_OWLDataPropertyData;
import edu.stanford.protege.webprotege.entity.OWLEntityDataVisitorEx;
import edu.stanford.protege.webprotege.entity.OWLPrimitiveDataVisitor;
import edu.stanford.protege.webprotege.entity.OWLPropertyData;
import edu.stanford.protege.webprotege.entity.PrimitiveType;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLEntityVisitorEx;
import uk.ac.manchester.cs.owl.owlapi.OWLDataPropertyImpl;

@JsonTypeName(value="DataPropertyData")
@AutoValue
public abstract class OWLDataPropertyData
extends OWLPropertyData {
    public static OWLDataPropertyData get(@Nonnull OWLDataProperty property, @Nonnull ImmutableMap<DictionaryLanguage, String> shortForms) {
        return OWLDataPropertyData.get(property, shortForms, false);
    }

    public static OWLDataPropertyData get(@Nonnull OWLDataProperty property, @Nonnull ImmutableMap<DictionaryLanguage, String> shortForms, boolean deprecated) {
        return OWLDataPropertyData.get(property, OWLDataPropertyData.toShortFormList(shortForms), deprecated);
    }

    public static OWLDataPropertyData get(@JsonProperty(value="entity") OWLDataProperty entity, @JsonProperty(value="shortForms") ImmutableList<ShortForm> shortForms, @JsonProperty(value="deprecated") boolean deprecated) {
        return new AutoValue_OWLDataPropertyData(shortForms, deprecated, entity);
    }

    @JsonCreator
    private static OWLDataPropertyData get(@JsonProperty(value="iri") String iri, @JsonProperty(value="shortForms", defaultValue="[]") ImmutableList<ShortForm> shortForms, @JsonProperty(value="deprecated") boolean deprecated) {
        return new AutoValue_OWLDataPropertyData((ImmutableList<ShortForm>)Objects.requireNonNullElse(shortForms, ImmutableList.of()), deprecated, (OWLDataProperty)new OWLDataPropertyImpl(IRI.create((String)iri)));
    }

    @Nonnull
    public abstract OWLDataProperty getObject();

    @Override
    public PrimitiveType getType() {
        return PrimitiveType.DATA_PROPERTY;
    }

    @Override
    public boolean isOWLAnnotationProperty() {
        return false;
    }

    @JsonIgnore
    public OWLDataProperty getEntity() {
        return this.getObject();
    }

    @JsonProperty(value="iri")
    private String getIri() {
        return this.getEntity().getIRI().toString();
    }

    @Override
    public <R, E extends Throwable> R accept(OWLPrimitiveDataVisitor<R, E> visitor) throws E {
        return visitor.visit(this);
    }

    @Override
    public <R> R accept(OWLEntityVisitorEx<R> visitor, R defaultValue) {
        return (R)visitor.visit(this.getEntity());
    }

    @Override
    public <R> R accept(OWLEntityDataVisitorEx<R> visitor) {
        return visitor.visit(this);
    }
}

