/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import edu.stanford.protege.webprotege.common.DictionaryLanguage;
import edu.stanford.protege.webprotege.common.ShortForm;
import edu.stanford.protege.webprotege.entity.AutoValue_OWLDatatypeData;
import edu.stanford.protege.webprotege.entity.OWLEntityData;
import edu.stanford.protege.webprotege.entity.OWLEntityDataVisitorEx;
import edu.stanford.protege.webprotege.entity.OWLPrimitiveDataVisitor;
import edu.stanford.protege.webprotege.entity.PrimitiveType;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntityVisitorEx;
import uk.ac.manchester.cs.owl.owlapi.OWLDatatypeImpl;

@JsonTypeName(value="DatatypeData")
@AutoValue
public abstract class OWLDatatypeData
extends OWLEntityData {
    public static OWLDatatypeData get(@Nonnull OWLDatatype datatype, @Nonnull ImmutableMap<DictionaryLanguage, String> shortForms) {
        return OWLDatatypeData.get(datatype, shortForms, false);
    }

    public static OWLDatatypeData get(@Nonnull OWLDatatype datatype, @Nonnull ImmutableMap<DictionaryLanguage, String> shortForms, boolean deprecated) {
        return OWLDatatypeData.get(datatype, OWLDatatypeData.toShortFormList(shortForms), deprecated);
    }

    public static OWLDatatypeData get(@JsonProperty(value="entity") OWLDatatype datatype, @JsonProperty(value="shortForms") ImmutableList<ShortForm> shortForms, @JsonProperty(value="deprecated") boolean deprecated) {
        return new AutoValue_OWLDatatypeData(shortForms, deprecated, datatype);
    }

    @JsonCreator
    private static OWLDatatypeData get(@JsonProperty(value="iri") String iri, @JsonProperty(value="shortForms", defaultValue="[]") ImmutableList<ShortForm> shortForms, @JsonProperty(value="deprecated", defaultValue="false") boolean deprecated) {
        return new AutoValue_OWLDatatypeData((ImmutableList<ShortForm>)Objects.requireNonNullElse(shortForms, ImmutableList.of()), deprecated, (OWLDatatype)new OWLDatatypeImpl(IRI.create((String)iri)));
    }

    @Nonnull
    public abstract OWLDatatype getObject();

    @Override
    public PrimitiveType getType() {
        return PrimitiveType.DATA_TYPE;
    }

    @JsonIgnore
    public OWLDatatype getEntity() {
        return this.getObject();
    }

    @JsonProperty(value="iri")
    private String getIri() {
        return this.getEntity().getIRI().toString();
    }

    @Override
    public <R, E extends Throwable> R accept(OWLPrimitiveDataVisitor<R, E> visitor) throws E {
        return visitor.visit(this);
    }

    @Override
    public <R> R accept(OWLEntityVisitorEx<R> visitor, R defaultValue) {
        return (R)visitor.visit(this.getEntity());
    }

    @Override
    public <R> R accept(OWLEntityDataVisitorEx<R> visitor) {
        return visitor.visit(this);
    }
}

