/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import edu.stanford.protege.webprotege.common.ShortForm;
import edu.stanford.protege.webprotege.entity.AutoValue_OWLLiteralData;
import edu.stanford.protege.webprotege.entity.OWLPrimitiveData;
import edu.stanford.protege.webprotege.entity.OWLPrimitiveDataVisitor;
import edu.stanford.protege.webprotege.entity.PrimitiveType;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitorEx;
import org.semanticweb.owlapi.model.OWLLiteral;
import uk.ac.manchester.cs.owl.owlapi.OWLDatatypeImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLLiteralImpl;

@JsonTypeName(value="LiteralData")
@AutoValue
public abstract class OWLLiteralData
extends OWLPrimitiveData {
    public static OWLLiteralData get(@Nonnull OWLLiteral literal) {
        return new AutoValue_OWLLiteralData(literal);
    }

    @JsonCreator
    private static OWLLiteralData get(@JsonProperty(value="value") String value, @JsonProperty(value="lang") String lang, @JsonProperty(value="datatype") String iri) {
        return OWLLiteralData.get((OWLLiteral)new OWLLiteralImpl(value, lang, (OWLDatatype)Optional.ofNullable(iri).map(IRI::create).map(OWLDatatypeImpl::new).orElse(null)));
    }

    @JsonIgnore
    @Nonnull
    public abstract OWLLiteral getObject();

    @Override
    @JsonIgnore
    public PrimitiveType getType() {
        return PrimitiveType.LITERAL;
    }

    @JsonIgnore
    public OWLLiteral getLiteral() {
        return this.getObject();
    }

    @JsonProperty(value="value")
    private String getValue() {
        return this.getLiteral().getLiteral();
    }

    @JsonProperty(value="lang")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String getLangTag() {
        return this.getLiteral().getLang();
    }

    @JsonProperty(value="datatype")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String getDatatype() {
        OWLDatatype datatype = this.getLiteral().getDatatype();
        if (datatype.isRDFPlainLiteral()) {
            return "";
        }
        return datatype.getIRI().toString();
    }

    @Override
    @JsonIgnore
    public String getBrowserText() {
        OWLLiteral literal = this.getLiteral();
        return literal.getLiteral();
    }

    @JsonIgnore
    public String getUnquotedBrowserText() {
        return this.getBrowserText();
    }

    @JsonIgnore
    public String getLexicalForm() {
        return this.getLiteral().getLiteral();
    }

    @JsonIgnore
    public boolean hasLang() {
        return this.getLiteral().hasLang();
    }

    @JsonIgnore
    @Nonnull
    public String getLang() {
        return this.getLiteral().getLang();
    }

    @Override
    public <R, E extends Throwable> R accept(OWLPrimitiveDataVisitor<R, E> visitor) throws E {
        return visitor.visit(this);
    }

    @Override
    public <R> R accept(OWLEntityVisitorEx<R> visitor, R defaultValue) {
        return defaultValue;
    }

    @Override
    public Optional<OWLAnnotationValue> asAnnotationValue() {
        return Optional.of(this.getLiteral());
    }

    @Override
    public Optional<OWLEntity> asEntity() {
        return Optional.empty();
    }

    @Override
    public Optional<OWLLiteral> asLiteral() {
        return Optional.of(this.getLiteral());
    }

    @Override
    @JsonIgnore
    public boolean isDeprecated() {
        return false;
    }

    @Override
    @JsonIgnore
    public ImmutableList<ShortForm> getShortForms() {
        return ImmutableList.of();
    }
}

