/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import edu.stanford.protege.webprotege.common.DictionaryLanguage;
import edu.stanford.protege.webprotege.common.ShortForm;
import edu.stanford.protege.webprotege.entity.AutoValue_OWLNamedIndividualData;
import edu.stanford.protege.webprotege.entity.OWLEntityData;
import edu.stanford.protege.webprotege.entity.OWLEntityDataVisitorEx;
import edu.stanford.protege.webprotege.entity.OWLPrimitiveDataVisitor;
import edu.stanford.protege.webprotege.entity.PrimitiveType;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLEntityVisitorEx;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import uk.ac.manchester.cs.owl.owlapi.OWLNamedIndividualImpl;

@JsonTypeName(value="NamedIndividualData")
@AutoValue
public abstract class OWLNamedIndividualData
extends OWLEntityData {
    public static OWLNamedIndividualData get(@Nonnull OWLNamedIndividual individual, @Nonnull ImmutableMap<DictionaryLanguage, String> shortForms) {
        return OWLNamedIndividualData.get(individual, shortForms, false);
    }

    public static OWLNamedIndividualData get(@Nonnull OWLNamedIndividual individual, @Nonnull ImmutableMap<DictionaryLanguage, String> shortForms, boolean deprecated) {
        return OWLNamedIndividualData.get(individual, OWLNamedIndividualData.toShortFormList(shortForms), deprecated);
    }

    public static OWLNamedIndividualData get(@JsonProperty(value="entity") OWLNamedIndividual individual, @JsonProperty(value="shortForms") ImmutableList<ShortForm> shortForms, @JsonProperty(value="deprecated") boolean deprecated) {
        return new AutoValue_OWLNamedIndividualData(shortForms, deprecated, individual);
    }

    @JsonCreator
    private static OWLNamedIndividualData get(@JsonProperty(value="iri") String iri, @JsonProperty(value="shortForms", defaultValue="[]") ImmutableList<ShortForm> shortForms, @JsonProperty(value="deprecated", defaultValue="false") boolean deprecated) {
        return new AutoValue_OWLNamedIndividualData((ImmutableList<ShortForm>)Objects.requireNonNullElse(shortForms, ImmutableList.of()), deprecated, (OWLNamedIndividual)new OWLNamedIndividualImpl(IRI.create((String)iri)));
    }

    @Nonnull
    public abstract OWLNamedIndividual getObject();

    @JsonIgnore
    public OWLNamedIndividual getEntity() {
        return this.getObject();
    }

    @JsonProperty(value="iri")
    private String getIri() {
        return this.getEntity().getIRI().toString();
    }

    @Override
    public PrimitiveType getType() {
        return PrimitiveType.NAMED_INDIVIDUAL;
    }

    @Override
    public <R, E extends Throwable> R accept(OWLPrimitiveDataVisitor<R, E> visitor) throws E {
        return visitor.visit(this);
    }

    @Override
    public <R> R accept(OWLEntityVisitorEx<R> visitor, R defaultValue) {
        return (R)visitor.visit(this.getEntity());
    }

    @Override
    public <R> R accept(OWLEntityDataVisitorEx<R> visitor) {
        return visitor.visit(this);
    }
}

