/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import edu.stanford.protege.webprotege.common.DictionaryLanguage;
import edu.stanford.protege.webprotege.common.ShortForm;
import edu.stanford.protege.webprotege.entity.AutoValue_OWLObjectPropertyData;
import edu.stanford.protege.webprotege.entity.OWLEntityDataVisitorEx;
import edu.stanford.protege.webprotege.entity.OWLPrimitiveDataVisitor;
import edu.stanford.protege.webprotege.entity.OWLPropertyData;
import edu.stanford.protege.webprotege.entity.PrimitiveType;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLEntityVisitorEx;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectPropertyImpl;

@JsonTypeName(value="ObjectPropertyData")
@AutoValue
public abstract class OWLObjectPropertyData
extends OWLPropertyData {
    public static OWLObjectPropertyData get(@Nonnull OWLObjectProperty property, @Nonnull ImmutableMap<DictionaryLanguage, String> shortForms) {
        return OWLObjectPropertyData.get(property, shortForms, false);
    }

    public static OWLObjectPropertyData get(@Nonnull OWLObjectProperty property, @Nonnull ImmutableMap<DictionaryLanguage, String> shortForms, boolean deprecated) {
        return OWLObjectPropertyData.get(property, OWLObjectPropertyData.toShortFormList(shortForms), deprecated);
    }

    public static OWLObjectPropertyData get(OWLObjectProperty property, ImmutableList<ShortForm> shortForms, boolean deprecated) {
        return new AutoValue_OWLObjectPropertyData((ImmutableList<ShortForm>)Objects.requireNonNullElse(shortForms, ImmutableList.of()), deprecated, property);
    }

    @JsonCreator
    private static OWLObjectPropertyData get(@JsonProperty(value="iri") String iri, @JsonProperty(value="shortForms", defaultValue="[]") ImmutableList<ShortForm> shortForms, @JsonProperty(value="deprecated", defaultValue="false") boolean deprecated) {
        return new AutoValue_OWLObjectPropertyData((ImmutableList<ShortForm>)Objects.requireNonNullElse(shortForms, ImmutableList.of()), deprecated, (OWLObjectProperty)new OWLObjectPropertyImpl(IRI.create((String)iri)));
    }

    @Nonnull
    public abstract OWLObjectProperty getObject();

    @Override
    public PrimitiveType getType() {
        return PrimitiveType.OBJECT_PROPERTY;
    }

    @JsonIgnore
    public OWLObjectProperty getEntity() {
        return this.getObject();
    }

    @JsonProperty(value="iri")
    private String getIri() {
        return this.getEntity().getIRI().toString();
    }

    @Override
    public boolean isOWLAnnotationProperty() {
        return false;
    }

    @Override
    public <R, E extends Throwable> R accept(OWLPrimitiveDataVisitor<R, E> visitor) throws E {
        return visitor.visit(this);
    }

    @Override
    public <R> R accept(OWLEntityVisitorEx<R> visitor, R defaultValue) {
        return (R)visitor.visit(this.getEntity());
    }

    @Override
    public <R> R accept(OWLEntityDataVisitorEx<R> visitor) {
        return visitor.visit(this);
    }
}

