/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import edu.stanford.protege.webprotege.common.DictionaryLanguage;
import edu.stanford.protege.webprotege.common.ShortForm;
import edu.stanford.protege.webprotege.entity.IRIData;
import edu.stanford.protege.webprotege.entity.OWLAnnotationPropertyData;
import edu.stanford.protege.webprotege.entity.OWLClassData;
import edu.stanford.protege.webprotege.entity.OWLDataPropertyData;
import edu.stanford.protege.webprotege.entity.OWLDatatypeData;
import edu.stanford.protege.webprotege.entity.OWLLiteralData;
import edu.stanford.protege.webprotege.entity.OWLNamedIndividualData;
import edu.stanford.protege.webprotege.entity.OWLObjectPropertyData;
import edu.stanford.protege.webprotege.entity.OWLPrimitiveDataVisitor;
import edu.stanford.protege.webprotege.entity.ObjectData;
import edu.stanford.protege.webprotege.entity.PrimitiveType;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitorEx;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLPrimitive;

@JsonSubTypes(value={@JsonSubTypes.Type(value=OWLClassData.class), @JsonSubTypes.Type(value=OWLObjectPropertyData.class), @JsonSubTypes.Type(value=OWLDataPropertyData.class), @JsonSubTypes.Type(value=OWLAnnotationPropertyData.class), @JsonSubTypes.Type(value=OWLNamedIndividualData.class), @JsonSubTypes.Type(value=OWLDatatypeData.class), @JsonSubTypes.Type(value=IRIData.class), @JsonSubTypes.Type(value=OWLLiteralData.class)})
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME)
public abstract class OWLPrimitiveData
extends ObjectData
implements Comparable<OWLPrimitiveData> {
    protected static ImmutableList<ShortForm> toShortFormList(@Nonnull ImmutableMap<DictionaryLanguage, String> shortForms) {
        return (ImmutableList)shortForms.entrySet().stream().map(e -> ShortForm.get((DictionaryLanguage)((DictionaryLanguage)e.getKey()), (String)((String)e.getValue()))).collect(ImmutableList.toImmutableList());
    }

    public Optional<IRI> asIRI() {
        return Optional.empty();
    }

    @Nonnull
    @JsonIgnore
    public abstract OWLPrimitive getObject();

    @JsonIgnore
    public ImmutableMap<DictionaryLanguage, String> getShortFormsMap() {
        return (ImmutableMap)this.getShortForms().stream().collect(ImmutableMap.toImmutableMap(ShortForm::getDictionaryLanguage, ShortForm::getShortForm));
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public abstract ImmutableList<ShortForm> getShortForms();

    @JsonIgnore
    public abstract String getBrowserText();

    protected String getFirstShortForm(Supplier<String> defaultValue) {
        return this.getShortForms().stream().findFirst().map(ShortForm::getShortForm).orElseGet(defaultValue);
    }

    public abstract <R, E extends Throwable> R accept(OWLPrimitiveDataVisitor<R, E> var1) throws E;

    public abstract <R> R accept(OWLEntityVisitorEx<R> var1, R var2);

    @JsonIgnore
    public abstract PrimitiveType getType();

    @JsonIgnore
    public boolean isOWLEntity() {
        return this.getObject() instanceof OWLEntity;
    }

    @JsonIgnore
    public boolean isIRI() {
        return this.getObject() instanceof IRI;
    }

    @JsonIgnore
    public boolean isOWLLiteral() {
        return this.getObject() instanceof OWLLiteral;
    }

    public abstract Optional<OWLAnnotationValue> asAnnotationValue();

    public abstract Optional<OWLEntity> asEntity();

    public Optional<OWLLiteral> asLiteral() {
        return Optional.empty();
    }

    @Override
    public int compareTo(OWLPrimitiveData o) {
        return this.getBrowserText().compareToIgnoreCase(o.getBrowserText());
    }

    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public abstract boolean isDeprecated();
}

