/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.frame;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import edu.stanford.protege.webprotege.entity.OWLClassData;
import edu.stanford.protege.webprotege.entity.OWLObjectPropertyData;
import edu.stanford.protege.webprotege.frame.ObjectPropertyCharacteristic;
import edu.stanford.protege.webprotege.frame.ObjectPropertyFrame;
import edu.stanford.protege.webprotege.frame.PropertyAnnotationValue;
import javax.annotation.Nonnull;

final class AutoValue_ObjectPropertyFrame
extends ObjectPropertyFrame {
    private final OWLObjectPropertyData subject;
    private final ImmutableSet<PropertyAnnotationValue> annotationPropertyValues;
    private final ImmutableSet<OWLClassData> domains;
    private final ImmutableSet<OWLClassData> ranges;
    private final ImmutableSet<ObjectPropertyCharacteristic> characteristics;
    private final ImmutableSet<OWLObjectPropertyData> inverseProperties;

    AutoValue_ObjectPropertyFrame(OWLObjectPropertyData subject, ImmutableSet<PropertyAnnotationValue> annotationPropertyValues, ImmutableSet<OWLClassData> domains, ImmutableSet<OWLClassData> ranges, ImmutableSet<ObjectPropertyCharacteristic> characteristics, ImmutableSet<OWLObjectPropertyData> inverseProperties) {
        if (subject == null) {
            throw new NullPointerException("Null subject");
        }
        this.subject = subject;
        if (annotationPropertyValues == null) {
            throw new NullPointerException("Null annotationPropertyValues");
        }
        this.annotationPropertyValues = annotationPropertyValues;
        if (domains == null) {
            throw new NullPointerException("Null domains");
        }
        this.domains = domains;
        if (ranges == null) {
            throw new NullPointerException("Null ranges");
        }
        this.ranges = ranges;
        if (characteristics == null) {
            throw new NullPointerException("Null characteristics");
        }
        this.characteristics = characteristics;
        if (inverseProperties == null) {
            throw new NullPointerException("Null inverseProperties");
        }
        this.inverseProperties = inverseProperties;
    }

    @Override
    @Nonnull
    public OWLObjectPropertyData getSubject() {
        return this.subject;
    }

    @Override
    @JsonProperty(value="propertyValues")
    @Nonnull
    public ImmutableSet<PropertyAnnotationValue> getAnnotationPropertyValues() {
        return this.annotationPropertyValues;
    }

    @Override
    @Nonnull
    public ImmutableSet<OWLClassData> getDomains() {
        return this.domains;
    }

    @Override
    @Nonnull
    public ImmutableSet<OWLClassData> getRanges() {
        return this.ranges;
    }

    @Override
    @Nonnull
    public ImmutableSet<ObjectPropertyCharacteristic> getCharacteristics() {
        return this.characteristics;
    }

    @Override
    @Nonnull
    public ImmutableSet<OWLObjectPropertyData> getInverseProperties() {
        return this.inverseProperties;
    }

    public String toString() {
        return "ObjectPropertyFrame{subject=" + this.subject + ", annotationPropertyValues=" + this.annotationPropertyValues + ", domains=" + this.domains + ", ranges=" + this.ranges + ", characteristics=" + this.characteristics + ", inverseProperties=" + this.inverseProperties + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ObjectPropertyFrame) {
            ObjectPropertyFrame that = (ObjectPropertyFrame)o;
            return this.subject.equals(that.getSubject()) && this.annotationPropertyValues.equals(that.getAnnotationPropertyValues()) && this.domains.equals(that.getDomains()) && this.ranges.equals(that.getRanges()) && this.characteristics.equals(that.getCharacteristics()) && this.inverseProperties.equals(that.getInverseProperties());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.subject.hashCode();
        h$ *= 1000003;
        h$ ^= this.annotationPropertyValues.hashCode();
        h$ *= 1000003;
        h$ ^= this.domains.hashCode();
        h$ *= 1000003;
        h$ ^= this.ranges.hashCode();
        h$ *= 1000003;
        h$ ^= this.characteristics.hashCode();
        h$ *= 1000003;
        return h$ ^= this.inverseProperties.hashCode();
    }
}

