/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.frame;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import edu.stanford.protege.webprotege.entity.OWLClassData;
import edu.stanford.protege.webprotege.entity.OWLDataPropertyData;
import edu.stanford.protege.webprotege.entity.OWLDatatypeData;
import edu.stanford.protege.webprotege.frame.AutoValue_DataPropertyFrame;
import edu.stanford.protege.webprotege.frame.EntityFrame;
import edu.stanford.protege.webprotege.frame.HasAnnotationPropertyValues;
import edu.stanford.protege.webprotege.frame.HasLogicalPropertyValues;
import edu.stanford.protege.webprotege.frame.HasPropertyValueList;
import edu.stanford.protege.webprotege.frame.HasPropertyValues;
import edu.stanford.protege.webprotege.frame.PlainDataPropertyFrame;
import edu.stanford.protege.webprotege.frame.PlainPropertyAnnotationValue;
import edu.stanford.protege.webprotege.frame.PropertyAnnotationValue;
import edu.stanford.protege.webprotege.frame.PropertyValue;
import edu.stanford.protege.webprotege.frame.PropertyValueList;
import java.io.Serializable;
import java.util.Collection;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDatatype;

@JsonTypeName(value="DataPropertyFrame")
@AutoValue
public abstract class DataPropertyFrame
implements EntityFrame<OWLDataPropertyData>,
Serializable,
HasPropertyValueList,
HasPropertyValues,
HasAnnotationPropertyValues,
HasLogicalPropertyValues {
    @JsonCreator
    @Nonnull
    public static DataPropertyFrame get(@JsonProperty(value="subject") @Nonnull OWLDataPropertyData subject, @JsonProperty(value="propertyValues") @Nonnull ImmutableSet<PropertyValue> propertyValues, @JsonProperty(value="domains") @Nonnull ImmutableSet<OWLClassData> domains, @JsonProperty(value="ranges") @Nonnull ImmutableSet<OWLDatatypeData> ranges, @JsonProperty(value="functional") boolean functional) {
        return new AutoValue_DataPropertyFrame(subject, propertyValues, domains, ranges, functional);
    }

    @Nonnull
    public static DataPropertyFrame empty(@Nonnull OWLDataPropertyData subject) {
        return DataPropertyFrame.get(subject, (ImmutableSet<PropertyValue>)ImmutableSet.of(), (ImmutableSet<OWLClassData>)ImmutableSet.of(), (ImmutableSet<OWLDatatypeData>)ImmutableSet.of(), false);
    }

    @Override
    public abstract OWLDataPropertyData getSubject();

    @Override
    public abstract ImmutableSet<PropertyValue> getPropertyValues();

    @Nonnull
    public abstract ImmutableSet<OWLClassData> getDomains();

    @Nonnull
    public abstract ImmutableSet<OWLDatatypeData> getRanges();

    public abstract boolean isFunctional();

    @Override
    @JsonIgnore
    public PropertyValueList getPropertyValueList() {
        return new PropertyValueList((Collection<? extends PropertyValue>)this.getPropertyValues());
    }

    @Override
    @JsonIgnore
    public ImmutableSet<PropertyAnnotationValue> getAnnotationPropertyValues() {
        return this.getPropertyValueList().getAnnotationPropertyValues();
    }

    @Override
    @JsonIgnore
    public ImmutableList<PropertyValue> getLogicalPropertyValues() {
        return this.getPropertyValueList().getLogicalPropertyValues();
    }

    @Override
    @Nonnull
    public PlainDataPropertyFrame toPlainFrame() {
        return PlainDataPropertyFrame.get(this.getSubject().getEntity(), (ImmutableSet<PlainPropertyAnnotationValue>)((ImmutableSet)this.getAnnotationPropertyValues().stream().map(PropertyAnnotationValue::toPlainPropertyValue).collect(ImmutableSet.toImmutableSet())), (ImmutableSet<OWLClass>)((ImmutableSet)this.getDomains().stream().map(OWLClassData::getEntity).collect(ImmutableSet.toImmutableSet())), (ImmutableSet<OWLDatatype>)((ImmutableSet)this.getRanges().stream().map(OWLDatatypeData::getEntity).collect(ImmutableSet.toImmutableSet())), this.isFunctional());
    }
}

