/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.frame;

import java.util.Collections;
import java.util.Set;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;

public enum ObjectPropertyCharacteristic {
    FUNCTIONAL("Functional"),
    INVERSE_FUNCTIONAL("Inverse Functional"),
    TRANSITIVE("Transitive"),
    SYMMETRIC("Symmetric"),
    ASYMMETRIC("Asymmetric"),
    REFLEXIVE("Reflexive"),
    IRREFLEXIVE("Irreflexive");

    private final String displayName;

    private ObjectPropertyCharacteristic(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public <A extends OWLAxiom> A createAxiom(OWLObjectPropertyExpression property, OWLDataFactory dataFactory) {
        return this.createAxiom(property, Collections.emptySet(), dataFactory);
    }

    public <A extends OWLAxiom> A createAxiom(OWLObjectPropertyExpression property, Set<? extends OWLAnnotation> annotations, OWLDataFactory dataFactory) {
        switch (this) {
            case FUNCTIONAL: {
                return (A)dataFactory.getOWLFunctionalObjectPropertyAxiom(property, annotations);
            }
            case INVERSE_FUNCTIONAL: {
                return (A)dataFactory.getOWLInverseFunctionalObjectPropertyAxiom(property, annotations);
            }
            case SYMMETRIC: {
                return (A)dataFactory.getOWLSymmetricObjectPropertyAxiom(property, annotations);
            }
            case ASYMMETRIC: {
                return (A)dataFactory.getOWLAsymmetricObjectPropertyAxiom(property, annotations);
            }
            case REFLEXIVE: {
                return (A)dataFactory.getOWLReflexiveObjectPropertyAxiom(property, annotations);
            }
            case IRREFLEXIVE: {
                return (A)dataFactory.getOWLIrreflexiveObjectPropertyAxiom(property, annotations);
            }
            case TRANSITIVE: {
                return (A)dataFactory.getOWLTransitiveObjectPropertyAxiom(property, annotations);
            }
        }
        throw new IllegalStateException("Missing case for property: " + this);
    }
}

