/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.frame;

import com.google.common.collect.ImmutableSet;
import edu.stanford.protege.webprotege.entity.OWLClassData;
import edu.stanford.protege.webprotege.entity.OWLDataPropertyData;
import edu.stanford.protege.webprotege.entity.OWLDatatypeData;
import edu.stanford.protege.webprotege.frame.DataPropertyFrame;
import edu.stanford.protege.webprotege.frame.PropertyValue;
import javax.annotation.Nonnull;

final class AutoValue_DataPropertyFrame
extends DataPropertyFrame {
    private final OWLDataPropertyData subject;
    private final ImmutableSet<PropertyValue> propertyValues;
    private final ImmutableSet<OWLClassData> domains;
    private final ImmutableSet<OWLDatatypeData> ranges;
    private final boolean functional;

    AutoValue_DataPropertyFrame(OWLDataPropertyData subject, ImmutableSet<PropertyValue> propertyValues, ImmutableSet<OWLClassData> domains, ImmutableSet<OWLDatatypeData> ranges, boolean functional) {
        if (subject == null) {
            throw new NullPointerException("Null subject");
        }
        this.subject = subject;
        if (propertyValues == null) {
            throw new NullPointerException("Null propertyValues");
        }
        this.propertyValues = propertyValues;
        if (domains == null) {
            throw new NullPointerException("Null domains");
        }
        this.domains = domains;
        if (ranges == null) {
            throw new NullPointerException("Null ranges");
        }
        this.ranges = ranges;
        this.functional = functional;
    }

    @Override
    public OWLDataPropertyData getSubject() {
        return this.subject;
    }

    @Override
    public ImmutableSet<PropertyValue> getPropertyValues() {
        return this.propertyValues;
    }

    @Override
    @Nonnull
    public ImmutableSet<OWLClassData> getDomains() {
        return this.domains;
    }

    @Override
    @Nonnull
    public ImmutableSet<OWLDatatypeData> getRanges() {
        return this.ranges;
    }

    @Override
    public boolean isFunctional() {
        return this.functional;
    }

    public String toString() {
        return "DataPropertyFrame{subject=" + this.subject + ", propertyValues=" + this.propertyValues + ", domains=" + this.domains + ", ranges=" + this.ranges + ", functional=" + this.functional + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof DataPropertyFrame) {
            DataPropertyFrame that = (DataPropertyFrame)o;
            return this.subject.equals(that.getSubject()) && this.propertyValues.equals(that.getPropertyValues()) && this.domains.equals(that.getDomains()) && this.ranges.equals(that.getRanges()) && this.functional == that.isFunctional();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.subject.hashCode();
        h$ *= 1000003;
        h$ ^= this.propertyValues.hashCode();
        h$ *= 1000003;
        h$ ^= this.domains.hashCode();
        h$ *= 1000003;
        h$ ^= this.ranges.hashCode();
        h$ *= 1000003;
        return h$ ^= this.functional ? 1231 : 1237;
    }
}

