/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.frame;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import edu.stanford.protege.webprotege.frame.HasAnnotationPropertyValues;
import edu.stanford.protege.webprotege.frame.HasPropertyValueList;
import edu.stanford.protege.webprotege.frame.HasPropertyValues;
import edu.stanford.protege.webprotege.frame.PropertyAnnotationValue;
import edu.stanford.protege.webprotege.frame.PropertyValue;
import edu.stanford.protege.webprotege.frame.PropertyValueList;
import java.io.Serializable;
import java.util.Set;
import org.semanticweb.owlapi.model.HasShortForm;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntologyID;

public class OntologyFrame
implements Serializable,
HasPropertyValueList,
HasPropertyValues,
HasAnnotationPropertyValues,
HasShortForm {
    private String shortForm;
    private OWLOntologyID subject;
    private PropertyValueList propertyValueList;

    private OntologyFrame() {
    }

    public OntologyFrame(OWLOntologyID subject, PropertyValueList propertyValueList, String shortForm) {
        this.subject = (OWLOntologyID)Preconditions.checkNotNull((Object)subject);
        this.propertyValueList = (PropertyValueList)Preconditions.checkNotNull((Object)propertyValueList);
        this.shortForm = (String)Preconditions.checkNotNull((Object)shortForm);
    }

    public String getShortForm() {
        return this.shortForm;
    }

    @Override
    public ImmutableSet<PropertyAnnotationValue> getAnnotationPropertyValues() {
        return this.propertyValueList.getAnnotationPropertyValues();
    }

    @Override
    public PropertyValueList getPropertyValueList() {
        return this.propertyValueList;
    }

    @Override
    public ImmutableSet<PropertyValue> getPropertyValues() {
        return this.propertyValueList.getPropertyValues();
    }

    public Set<OWLEntity> getSignature() {
        return this.propertyValueList.getSignature();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.subject, this.propertyValueList, this.shortForm});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OntologyFrame)) {
            return false;
        }
        OntologyFrame other = (OntologyFrame)obj;
        return this.subject.equals((Object)other.subject) && this.propertyValueList.equals(other.propertyValueList) && this.shortForm.equals(other.shortForm);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"OntologyFrame").addValue((Object)this.subject).addValue((Object)this.propertyValueList).add("shortForm", (Object)this.shortForm).toString();
    }
}

