/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.frame;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableSet;
import edu.stanford.protege.webprotege.frame.AutoValue_PlainDataPropertyFrame;
import edu.stanford.protege.webprotege.frame.PlainEntityFrame;
import edu.stanford.protege.webprotege.frame.PlainPropertyAnnotationValue;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;

@JsonTypeName(value="DataPropertyFrame")
@AutoValue
public abstract class PlainDataPropertyFrame
extends PlainEntityFrame {
    public static final String DATA_PROPERTY_FRAME = "DataPropertyFrame";
    public static final String DOMAINS = "domains";
    public static final String RANGES = "ranges";
    public static final String FUNCTIONAL = "functional";

    @JsonCreator
    public static PlainDataPropertyFrame get(@Nonnull @JsonProperty(value="subject") OWLDataProperty subject, @Nonnull @JsonProperty(value="propertyValues") ImmutableSet<PlainPropertyAnnotationValue> annotations, @Nonnull @JsonProperty(value="domains") ImmutableSet<OWLClass> domains, @Nonnull @JsonProperty(value="ranges") ImmutableSet<OWLDatatype> ranges, @JsonProperty(value="functional") boolean functional) {
        return new AutoValue_PlainDataPropertyFrame(subject, annotations, domains, ranges, functional);
    }

    public static PlainDataPropertyFrame empty(OWLDataProperty property) {
        return PlainDataPropertyFrame.get(property, (ImmutableSet<PlainPropertyAnnotationValue>)ImmutableSet.of(), (ImmutableSet<OWLClass>)ImmutableSet.of(), (ImmutableSet<OWLDatatype>)ImmutableSet.of(), false);
    }

    @Override
    @Nonnull
    public abstract OWLDataProperty getSubject();

    @Nonnull
    public abstract ImmutableSet<PlainPropertyAnnotationValue> getPropertyValues();

    @JsonProperty(value="domains")
    @Nonnull
    public abstract ImmutableSet<OWLClass> getDomains();

    @JsonProperty(value="ranges")
    @Nonnull
    public abstract ImmutableSet<OWLDatatype> getRanges();

    @JsonProperty(value="functional")
    public abstract boolean isFunctional();

    @Override
    @Nonnull
    public PlainDataPropertyFrame toPlainFrame() {
        return this;
    }
}

