/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.frame;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.auto.value.AutoValue;
import edu.stanford.protege.webprotege.entity.OWLAnnotationPropertyData;
import edu.stanford.protege.webprotege.entity.OWLEntityData;
import edu.stanford.protege.webprotege.entity.OWLPrimitiveData;
import edu.stanford.protege.webprotege.frame.AutoValue_PropertyAnnotationValue;
import edu.stanford.protege.webprotege.frame.PlainPropertyAnnotationValue;
import edu.stanford.protege.webprotege.frame.PropertyValue;
import edu.stanford.protege.webprotege.frame.PropertyValueVisitor;
import edu.stanford.protege.webprotege.frame.State;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLAnnotationValue;

@JsonTypeName(value="PropertyAnnotationValue")
@AutoValue
public abstract class PropertyAnnotationValue
extends PropertyValue {
    @JsonCreator
    @Nonnull
    public static PropertyAnnotationValue get(@JsonProperty(value="property") @Nonnull OWLAnnotationPropertyData property, @JsonProperty(value="value") @Nonnull OWLPrimitiveData value, @JsonProperty(value="state") @Nonnull State state) {
        return new AutoValue_PropertyAnnotationValue(property, value, state);
    }

    public abstract OWLAnnotationPropertyData getProperty();

    @Override
    public abstract OWLPrimitiveData getValue();

    @Override
    public abstract State getState();

    @JsonIgnore
    @Nonnull
    public Optional<OWLEntityData> getValueAsEntity() {
        OWLPrimitiveData primitiveData = this.getValue();
        if (primitiveData instanceof OWLEntityData) {
            return Optional.of((OWLEntityData)primitiveData);
        }
        return Optional.empty();
    }

    @Override
    public boolean isValueMostSpecific() {
        return true;
    }

    @Override
    public boolean isAnnotation() {
        return true;
    }

    @Override
    public boolean isLogical() {
        return false;
    }

    @Override
    protected PropertyValue duplicateWithState(State state) {
        return PropertyAnnotationValue.get(this.getProperty(), this.getValue(), state);
    }

    @Override
    @Nonnull
    public PlainPropertyAnnotationValue toPlainPropertyValue() {
        return PlainPropertyAnnotationValue.get(this.getProperty().getEntity(), (OWLAnnotationValue)this.getValue().asAnnotationValue().get(), this.getState());
    }

    @Override
    public <R, E extends Throwable> R accept(PropertyValueVisitor<R, E> visitor) throws E {
        return visitor.visit(this);
    }
}

