/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.frame;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableSet;
import edu.stanford.protege.webprotege.entity.OWLAnnotationPropertyData;
import edu.stanford.protege.webprotege.entity.OWLEntityData;
import edu.stanford.protege.webprotege.frame.AutoValue_AnnotationPropertyFrame;
import edu.stanford.protege.webprotege.frame.EntityFrame;
import edu.stanford.protege.webprotege.frame.HasPropertyValueList;
import edu.stanford.protege.webprotege.frame.PlainAnnotationPropertyFrame;
import edu.stanford.protege.webprotege.frame.PlainPropertyAnnotationValue;
import edu.stanford.protege.webprotege.frame.PropertyAnnotationValue;
import edu.stanford.protege.webprotege.frame.PropertyValue;
import edu.stanford.protege.webprotege.frame.PropertyValueList;
import java.util.Collection;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLNamedObject;

@JsonTypeName(value="AnnotationPropertyFrame")
@AutoValue
public abstract class AnnotationPropertyFrame
implements EntityFrame<OWLAnnotationPropertyData>,
HasPropertyValueList {
    @Nonnull
    public static AnnotationPropertyFrame empty(@Nonnull OWLAnnotationPropertyData subject) {
        return AnnotationPropertyFrame.get(subject, (ImmutableSet<PropertyAnnotationValue>)ImmutableSet.of(), (ImmutableSet<OWLEntityData>)ImmutableSet.of(), (ImmutableSet<OWLEntityData>)ImmutableSet.of());
    }

    @Override
    @Nonnull
    public abstract OWLAnnotationPropertyData getSubject();

    @Nonnull
    public abstract ImmutableSet<PropertyAnnotationValue> getPropertyValues();

    @Nonnull
    public abstract ImmutableSet<OWLEntityData> getDomains();

    @Nonnull
    public abstract ImmutableSet<OWLEntityData> getRanges();

    @JsonCreator
    @Nonnull
    public static AnnotationPropertyFrame get(@JsonProperty(value="subject") @Nonnull OWLAnnotationPropertyData subject, @JsonProperty(value="propertyValues") @Nonnull ImmutableSet<PropertyAnnotationValue> propertyValues, @JsonProperty(value="domains") @Nonnull ImmutableSet<OWLEntityData> domains, @JsonProperty(value="ranges") @Nonnull ImmutableSet<OWLEntityData> ranges) {
        return new AutoValue_AnnotationPropertyFrame(subject, propertyValues, domains, ranges);
    }

    @Override
    @JsonIgnore
    public PropertyValueList getPropertyValueList() {
        return new PropertyValueList((Collection<? extends PropertyValue>)this.getPropertyValues());
    }

    @Override
    @Nonnull
    public PlainAnnotationPropertyFrame toPlainFrame() {
        return PlainAnnotationPropertyFrame.get(this.getSubject().getEntity(), (ImmutableSet<PlainPropertyAnnotationValue>)((ImmutableSet)this.getPropertyValues().stream().map(PropertyAnnotationValue::toPlainPropertyValue).collect(ImmutableSet.toImmutableSet())), (ImmutableSet<IRI>)((ImmutableSet)this.getDomains().stream().map(OWLEntityData::getEntity).map(OWLNamedObject::getIRI).collect(ImmutableSet.toImmutableSet())), (ImmutableSet<IRI>)((ImmutableSet)this.getRanges().stream().map(OWLEntityData::getEntity).map(OWLNamedObject::getIRI).collect(ImmutableSet.toImmutableSet())));
    }
}

