/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.frame;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import edu.stanford.protege.webprotege.entity.OWLClassData;
import edu.stanford.protege.webprotege.frame.ClassFrame;
import edu.stanford.protege.webprotege.frame.PropertyValue;
import javax.annotation.Nonnull;

final class AutoValue_ClassFrame
extends ClassFrame {
    private final OWLClassData subject;
    private final ImmutableSet<OWLClassData> classEntries;
    private final ImmutableSet<PropertyValue> propertyValues;

    AutoValue_ClassFrame(OWLClassData subject, ImmutableSet<OWLClassData> classEntries, ImmutableSet<PropertyValue> propertyValues) {
        if (subject == null) {
            throw new NullPointerException("Null subject");
        }
        this.subject = subject;
        if (classEntries == null) {
            throw new NullPointerException("Null classEntries");
        }
        this.classEntries = classEntries;
        if (propertyValues == null) {
            throw new NullPointerException("Null propertyValues");
        }
        this.propertyValues = propertyValues;
    }

    @Override
    @JsonProperty(value="subject")
    @Nonnull
    public OWLClassData getSubject() {
        return this.subject;
    }

    @Override
    @JsonProperty(value="classes")
    @Nonnull
    public ImmutableSet<OWLClassData> getClassEntries() {
        return this.classEntries;
    }

    @Override
    @JsonProperty(value="propertyValues")
    @Nonnull
    public ImmutableSet<PropertyValue> getPropertyValues() {
        return this.propertyValues;
    }

    public String toString() {
        return "ClassFrame{subject=" + this.subject + ", classEntries=" + this.classEntries + ", propertyValues=" + this.propertyValues + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ClassFrame) {
            ClassFrame that = (ClassFrame)o;
            return this.subject.equals(that.getSubject()) && this.classEntries.equals(that.getClassEntries()) && this.propertyValues.equals(that.getPropertyValues());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.subject.hashCode();
        h$ *= 1000003;
        h$ ^= this.classEntries.hashCode();
        h$ *= 1000003;
        return h$ ^= this.propertyValues.hashCode();
    }
}

