/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.frame;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import edu.stanford.protege.webprotege.frame.PlainDataPropertyFrame;
import edu.stanford.protege.webprotege.frame.PlainPropertyAnnotationValue;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;

final class AutoValue_PlainDataPropertyFrame
extends PlainDataPropertyFrame {
    private final OWLDataProperty subject;
    private final ImmutableSet<PlainPropertyAnnotationValue> propertyValues;
    private final ImmutableSet<OWLClass> domains;
    private final ImmutableSet<OWLDatatype> ranges;
    private final boolean functional;

    AutoValue_PlainDataPropertyFrame(OWLDataProperty subject, ImmutableSet<PlainPropertyAnnotationValue> propertyValues, ImmutableSet<OWLClass> domains, ImmutableSet<OWLDatatype> ranges, boolean functional) {
        if (subject == null) {
            throw new NullPointerException("Null subject");
        }
        this.subject = subject;
        if (propertyValues == null) {
            throw new NullPointerException("Null propertyValues");
        }
        this.propertyValues = propertyValues;
        if (domains == null) {
            throw new NullPointerException("Null domains");
        }
        this.domains = domains;
        if (ranges == null) {
            throw new NullPointerException("Null ranges");
        }
        this.ranges = ranges;
        this.functional = functional;
    }

    @Override
    @Nonnull
    public OWLDataProperty getSubject() {
        return this.subject;
    }

    @Override
    @Nonnull
    public ImmutableSet<PlainPropertyAnnotationValue> getPropertyValues() {
        return this.propertyValues;
    }

    @Override
    @JsonProperty(value="domains")
    @Nonnull
    public ImmutableSet<OWLClass> getDomains() {
        return this.domains;
    }

    @Override
    @JsonProperty(value="ranges")
    @Nonnull
    public ImmutableSet<OWLDatatype> getRanges() {
        return this.ranges;
    }

    @Override
    @JsonProperty(value="functional")
    public boolean isFunctional() {
        return this.functional;
    }

    public String toString() {
        return "PlainDataPropertyFrame{subject=" + this.subject + ", propertyValues=" + this.propertyValues + ", domains=" + this.domains + ", ranges=" + this.ranges + ", functional=" + this.functional + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof PlainDataPropertyFrame) {
            PlainDataPropertyFrame that = (PlainDataPropertyFrame)o;
            return this.subject.equals(that.getSubject()) && this.propertyValues.equals(that.getPropertyValues()) && this.domains.equals(that.getDomains()) && this.ranges.equals(that.getRanges()) && this.functional == that.isFunctional();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.subject.hashCode();
        h$ *= 1000003;
        h$ ^= this.propertyValues.hashCode();
        h$ *= 1000003;
        h$ ^= this.domains.hashCode();
        h$ *= 1000003;
        h$ ^= this.ranges.hashCode();
        h$ *= 1000003;
        return h$ ^= this.functional ? 1231 : 1237;
    }
}

