/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.frame;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import edu.stanford.protege.webprotege.frame.ObjectPropertyCharacteristic;
import edu.stanford.protege.webprotege.frame.PlainObjectPropertyFrame;
import edu.stanford.protege.webprotege.frame.PlainPropertyAnnotationValue;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLObjectProperty;

final class AutoValue_PlainObjectPropertyFrame
extends PlainObjectPropertyFrame {
    private final OWLObjectProperty subject;
    private final ImmutableSet<PlainPropertyAnnotationValue> propertyValues;
    private final ImmutableSet<ObjectPropertyCharacteristic> characteristics;
    private final ImmutableSet<OWLClass> domains;
    private final ImmutableSet<OWLClass> ranges;
    private final ImmutableSet<OWLObjectProperty> inverseProperties;

    AutoValue_PlainObjectPropertyFrame(OWLObjectProperty subject, ImmutableSet<PlainPropertyAnnotationValue> propertyValues, ImmutableSet<ObjectPropertyCharacteristic> characteristics, ImmutableSet<OWLClass> domains, ImmutableSet<OWLClass> ranges, ImmutableSet<OWLObjectProperty> inverseProperties) {
        if (subject == null) {
            throw new NullPointerException("Null subject");
        }
        this.subject = subject;
        if (propertyValues == null) {
            throw new NullPointerException("Null propertyValues");
        }
        this.propertyValues = propertyValues;
        if (characteristics == null) {
            throw new NullPointerException("Null characteristics");
        }
        this.characteristics = characteristics;
        if (domains == null) {
            throw new NullPointerException("Null domains");
        }
        this.domains = domains;
        if (ranges == null) {
            throw new NullPointerException("Null ranges");
        }
        this.ranges = ranges;
        if (inverseProperties == null) {
            throw new NullPointerException("Null inverseProperties");
        }
        this.inverseProperties = inverseProperties;
    }

    @Override
    @Nonnull
    public OWLObjectProperty getSubject() {
        return this.subject;
    }

    @Override
    @Nonnull
    public ImmutableSet<PlainPropertyAnnotationValue> getPropertyValues() {
        return this.propertyValues;
    }

    @Override
    @JsonProperty(value="characteristics")
    @Nonnull
    public ImmutableSet<ObjectPropertyCharacteristic> getCharacteristics() {
        return this.characteristics;
    }

    @Override
    @JsonProperty(value="domains")
    @Nonnull
    public ImmutableSet<OWLClass> getDomains() {
        return this.domains;
    }

    @Override
    @JsonProperty(value="ranges")
    @Nonnull
    public ImmutableSet<OWLClass> getRanges() {
        return this.ranges;
    }

    @Override
    @JsonProperty(value="inverses")
    @Nonnull
    public ImmutableSet<OWLObjectProperty> getInverseProperties() {
        return this.inverseProperties;
    }

    public String toString() {
        return "PlainObjectPropertyFrame{subject=" + this.subject + ", propertyValues=" + this.propertyValues + ", characteristics=" + this.characteristics + ", domains=" + this.domains + ", ranges=" + this.ranges + ", inverseProperties=" + this.inverseProperties + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof PlainObjectPropertyFrame) {
            PlainObjectPropertyFrame that = (PlainObjectPropertyFrame)o;
            return this.subject.equals(that.getSubject()) && this.propertyValues.equals(that.getPropertyValues()) && this.characteristics.equals(that.getCharacteristics()) && this.domains.equals(that.getDomains()) && this.ranges.equals(that.getRanges()) && this.inverseProperties.equals(that.getInverseProperties());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.subject.hashCode();
        h$ *= 1000003;
        h$ ^= this.propertyValues.hashCode();
        h$ *= 1000003;
        h$ ^= this.characteristics.hashCode();
        h$ *= 1000003;
        h$ ^= this.domains.hashCode();
        h$ *= 1000003;
        h$ ^= this.ranges.hashCode();
        h$ *= 1000003;
        return h$ ^= this.inverseProperties.hashCode();
    }
}

