/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.frame;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import edu.stanford.protege.webprotege.entity.OWLClassData;
import edu.stanford.protege.webprotege.frame.AutoValue_ClassFrame;
import edu.stanford.protege.webprotege.frame.EntityFrame;
import edu.stanford.protege.webprotege.frame.HasAnnotationPropertyValues;
import edu.stanford.protege.webprotege.frame.HasLogicalPropertyValues;
import edu.stanford.protege.webprotege.frame.HasPropertyValueList;
import edu.stanford.protege.webprotege.frame.HasPropertyValues;
import edu.stanford.protege.webprotege.frame.PlainClassFrame;
import edu.stanford.protege.webprotege.frame.PlainPropertyValue;
import edu.stanford.protege.webprotege.frame.PropertyAnnotationValue;
import edu.stanford.protege.webprotege.frame.PropertyValue;
import edu.stanford.protege.webprotege.frame.PropertyValueList;
import java.io.Serializable;
import java.util.Collection;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLClass;

@JsonTypeName(value="ClassFrame")
@AutoValue
public abstract class ClassFrame
implements EntityFrame<OWLClassData>,
Serializable,
HasPropertyValueList,
HasPropertyValues,
HasAnnotationPropertyValues,
HasLogicalPropertyValues {
    @JsonCreator
    @Nonnull
    public static ClassFrame get(@JsonProperty(value="subject") @Nonnull OWLClassData subject, @JsonProperty(value="classes") @Nonnull ImmutableSet<OWLClassData> classEntries, @JsonProperty(value="propertyValues") @Nonnull ImmutableSet<PropertyValue> propertyValues) {
        return new AutoValue_ClassFrame(subject, classEntries, propertyValues);
    }

    public static ClassFrame empty(@Nonnull OWLClassData subject) {
        return ClassFrame.get(subject, (ImmutableSet<OWLClassData>)ImmutableSet.of(), (ImmutableSet<PropertyValue>)ImmutableSet.of());
    }

    @Override
    @JsonProperty(value="subject")
    @Nonnull
    public abstract OWLClassData getSubject();

    @JsonProperty(value="classes")
    @Nonnull
    public abstract ImmutableSet<OWLClassData> getClassEntries();

    @Override
    @JsonProperty(value="propertyValues")
    @Nonnull
    public abstract ImmutableSet<PropertyValue> getPropertyValues();

    @Override
    @JsonIgnore
    @Nonnull
    public PropertyValueList getPropertyValueList() {
        return new PropertyValueList((Collection<? extends PropertyValue>)this.getPropertyValues());
    }

    @Override
    @JsonIgnore
    @Nonnull
    public ImmutableSet<PropertyAnnotationValue> getAnnotationPropertyValues() {
        return this.getPropertyValueList().getAnnotationPropertyValues();
    }

    @Override
    @JsonIgnore
    @Nonnull
    public ImmutableList<PropertyValue> getLogicalPropertyValues() {
        return this.getPropertyValueList().getLogicalPropertyValues();
    }

    @Override
    @Nonnull
    public PlainClassFrame toPlainFrame() {
        return PlainClassFrame.get(this.getSubject().getEntity(), (ImmutableSet<OWLClass>)((ImmutableSet)this.getClassEntries().stream().map(OWLClassData::getEntity).collect(ImmutableSet.toImmutableSet())), (ImmutableSet<PlainPropertyValue>)((ImmutableSet)this.getPropertyValues().stream().map(PropertyValue::toPlainPropertyValue).collect(ImmutableSet.toImmutableSet())));
    }
}

