/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.frame;

import com.google.auto.value.AutoValue;
import edu.stanford.protege.webprotege.frame.AutoValue_FrameUpdate;
import edu.stanford.protege.webprotege.frame.PlainAnnotationPropertyFrame;
import edu.stanford.protege.webprotege.frame.PlainClassFrame;
import edu.stanford.protege.webprotege.frame.PlainDataPropertyFrame;
import edu.stanford.protege.webprotege.frame.PlainEntityFrame;
import edu.stanford.protege.webprotege.frame.PlainNamedIndividualFrame;
import edu.stanford.protege.webprotege.frame.PlainObjectPropertyFrame;
import javax.annotation.Nonnull;

@AutoValue
public abstract class FrameUpdate {
    public static FrameUpdate get(PlainEntityFrame from, PlainEntityFrame to) {
        if (!from.getClass().equals(to.getClass())) {
            throw new RuntimeException("Frames must be of the same type");
        }
        if (from instanceof PlainClassFrame) {
            return FrameUpdate.get((PlainClassFrame)from, (PlainClassFrame)to);
        }
        if (from instanceof PlainNamedIndividualFrame) {
            return FrameUpdate.get((PlainNamedIndividualFrame)from, (PlainNamedIndividualFrame)to);
        }
        if (from instanceof PlainObjectPropertyFrame) {
            return FrameUpdate.get((PlainObjectPropertyFrame)from, (PlainObjectPropertyFrame)to);
        }
        if (from instanceof PlainDataPropertyFrame) {
            return FrameUpdate.get((PlainDataPropertyFrame)from, (PlainDataPropertyFrame)to);
        }
        if (from instanceof PlainAnnotationPropertyFrame) {
            return FrameUpdate.get((PlainAnnotationPropertyFrame)from, (PlainAnnotationPropertyFrame)to);
        }
        throw new RuntimeException("Unknown frame type: " + from);
    }

    public static FrameUpdate get(@Nonnull PlainClassFrame fromFrame, @Nonnull PlainClassFrame toFrame) {
        return new AutoValue_FrameUpdate(fromFrame, toFrame);
    }

    public static FrameUpdate get(@Nonnull PlainNamedIndividualFrame fromFrame, @Nonnull PlainNamedIndividualFrame toFrame) {
        return new AutoValue_FrameUpdate(fromFrame, toFrame);
    }

    public static FrameUpdate get(@Nonnull PlainObjectPropertyFrame fromFrame, @Nonnull PlainObjectPropertyFrame toFrame) {
        return new AutoValue_FrameUpdate(fromFrame, toFrame);
    }

    public static FrameUpdate get(@Nonnull PlainDataPropertyFrame fromFrame, @Nonnull PlainDataPropertyFrame toFrame) {
        return new AutoValue_FrameUpdate(fromFrame, toFrame);
    }

    public static FrameUpdate get(@Nonnull PlainAnnotationPropertyFrame fromFrame, @Nonnull PlainAnnotationPropertyFrame toFrame) {
        return new AutoValue_FrameUpdate(fromFrame, toFrame);
    }

    public abstract PlainEntityFrame getFromFrame();

    public abstract PlainEntityFrame getToFrame();
}

