/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.frame;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import edu.stanford.protege.webprotege.entity.OWLClassData;
import edu.stanford.protege.webprotege.entity.OWLNamedIndividualData;
import edu.stanford.protege.webprotege.frame.AutoValue_NamedIndividualFrame;
import edu.stanford.protege.webprotege.frame.EntityFrame;
import edu.stanford.protege.webprotege.frame.HasAnnotationPropertyValues;
import edu.stanford.protege.webprotege.frame.HasLogicalPropertyValues;
import edu.stanford.protege.webprotege.frame.HasPropertyValueList;
import edu.stanford.protege.webprotege.frame.HasPropertyValues;
import edu.stanford.protege.webprotege.frame.PlainNamedIndividualFrame;
import edu.stanford.protege.webprotege.frame.PlainPropertyValue;
import edu.stanford.protege.webprotege.frame.PropertyAnnotationValue;
import edu.stanford.protege.webprotege.frame.PropertyValue;
import edu.stanford.protege.webprotege.frame.PropertyValueList;
import java.io.Serializable;
import java.util.Collection;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLNamedIndividual;

@JsonTypeName(value="NamedIndividualFrame")
@AutoValue
public abstract class NamedIndividualFrame
implements EntityFrame<OWLNamedIndividualData>,
HasPropertyValues,
HasAnnotationPropertyValues,
HasLogicalPropertyValues,
HasPropertyValueList,
Serializable {
    @JsonCreator
    @Nonnull
    public static NamedIndividualFrame get(@JsonProperty(value="subject") @Nonnull OWLNamedIndividualData subject, @JsonProperty(value="classes") @Nonnull ImmutableSet<OWLClassData> namedTypes, @JsonProperty(value="propertyValues") @Nonnull ImmutableSet<PropertyValue> propertyValueList, @JsonProperty(value="sameIndividuals") @Nonnull ImmutableSet<OWLNamedIndividualData> sameIndividuals) {
        return new AutoValue_NamedIndividualFrame(subject, namedTypes, propertyValueList, sameIndividuals);
    }

    @Nonnull
    public static NamedIndividualFrame empty(@Nonnull OWLNamedIndividualData subject) {
        return NamedIndividualFrame.get(subject, (ImmutableSet<OWLClassData>)ImmutableSet.of(), (ImmutableSet<PropertyValue>)ImmutableSet.of(), (ImmutableSet<OWLNamedIndividualData>)ImmutableSet.of());
    }

    @Override
    @Nonnull
    public abstract OWLNamedIndividualData getSubject();

    @Nonnull
    public abstract ImmutableSet<OWLClassData> getClasses();

    @Override
    @Nonnull
    public abstract ImmutableSet<PropertyValue> getPropertyValues();

    @Nonnull
    public abstract ImmutableSet<OWLNamedIndividualData> getSameIndividuals();

    @Override
    @JsonIgnore
    public ImmutableSet<PropertyAnnotationValue> getAnnotationPropertyValues() {
        return this.getPropertyValueList().getAnnotationPropertyValues();
    }

    @Override
    @Nonnull
    @JsonIgnore
    public ImmutableList<PropertyValue> getLogicalPropertyValues() {
        return this.getPropertyValueList().getLogicalPropertyValues();
    }

    @Override
    @Nonnull
    @JsonIgnore
    public PropertyValueList getPropertyValueList() {
        return new PropertyValueList((Collection<? extends PropertyValue>)this.getPropertyValues());
    }

    @Override
    @Nonnull
    @JsonIgnore
    public PlainNamedIndividualFrame toPlainFrame() {
        return PlainNamedIndividualFrame.get(this.getSubject().getEntity(), (ImmutableSet<OWLClass>)((ImmutableSet)this.getClasses().stream().map(OWLClassData::getEntity).collect(ImmutableSet.toImmutableSet())), (ImmutableSet<OWLNamedIndividual>)((ImmutableSet)this.getSameIndividuals().stream().map(OWLNamedIndividualData::getEntity).collect(ImmutableSet.toImmutableSet())), (ImmutableSet<PlainPropertyValue>)((ImmutableSet)this.getPropertyValues().stream().map(PropertyValue::toPlainPropertyValue).collect(ImmutableSet.toImmutableSet())));
    }
}

