/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.frame;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableSet;
import edu.stanford.protege.webprotege.entity.OWLClassData;
import edu.stanford.protege.webprotege.entity.OWLObjectPropertyData;
import edu.stanford.protege.webprotege.frame.AutoValue_ObjectPropertyFrame;
import edu.stanford.protege.webprotege.frame.EntityFrame;
import edu.stanford.protege.webprotege.frame.HasAnnotationPropertyValues;
import edu.stanford.protege.webprotege.frame.ObjectPropertyCharacteristic;
import edu.stanford.protege.webprotege.frame.PlainObjectPropertyFrame;
import edu.stanford.protege.webprotege.frame.PlainPropertyAnnotationValue;
import edu.stanford.protege.webprotege.frame.PropertyAnnotationValue;
import java.io.Serializable;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLObjectProperty;

@JsonTypeName(value="ObjectPropertyFrame")
@AutoValue
public abstract class ObjectPropertyFrame
implements EntityFrame<OWLObjectPropertyData>,
HasAnnotationPropertyValues,
Serializable {
    @JsonCreator
    @Nonnull
    public static ObjectPropertyFrame get(@JsonProperty(value="subject") @Nonnull OWLObjectPropertyData subject, @JsonProperty(value="propertyValues") @Nonnull ImmutableSet<PropertyAnnotationValue> annotationValues, @JsonProperty(value="domains") @Nonnull ImmutableSet<OWLClassData> domains, @JsonProperty(value="ranges") @Nonnull ImmutableSet<OWLClassData> ranges, @JsonProperty(value="inverseProperties") @Nonnull ImmutableSet<OWLObjectPropertyData> inverseProperties, @JsonProperty(value="characteristics") @Nonnull ImmutableSet<ObjectPropertyCharacteristic> characteristics) {
        return new AutoValue_ObjectPropertyFrame(subject, annotationValues, domains, ranges, characteristics, inverseProperties);
    }

    @Nonnull
    public static ObjectPropertyFrame empty(@Nonnull OWLObjectPropertyData subject) {
        return ObjectPropertyFrame.get(subject, (ImmutableSet<PropertyAnnotationValue>)ImmutableSet.of(), (ImmutableSet<OWLClassData>)ImmutableSet.of(), (ImmutableSet<OWLClassData>)ImmutableSet.of(), (ImmutableSet<OWLObjectPropertyData>)ImmutableSet.of(), (ImmutableSet<ObjectPropertyCharacteristic>)ImmutableSet.of());
    }

    @Override
    @Nonnull
    public abstract OWLObjectPropertyData getSubject();

    @Override
    @JsonProperty(value="propertyValues")
    @Nonnull
    public abstract ImmutableSet<PropertyAnnotationValue> getAnnotationPropertyValues();

    @Nonnull
    public abstract ImmutableSet<OWLClassData> getDomains();

    @Nonnull
    public abstract ImmutableSet<OWLClassData> getRanges();

    @Nonnull
    public abstract ImmutableSet<ObjectPropertyCharacteristic> getCharacteristics();

    @Nonnull
    public abstract ImmutableSet<OWLObjectPropertyData> getInverseProperties();

    @Override
    @Nonnull
    public PlainObjectPropertyFrame toPlainFrame() {
        return PlainObjectPropertyFrame.get(this.getSubject().getEntity(), (ImmutableSet<PlainPropertyAnnotationValue>)((ImmutableSet)this.getAnnotationPropertyValues().stream().map(PropertyAnnotationValue::toPlainPropertyValue).collect(ImmutableSet.toImmutableSet())), this.getCharacteristics(), (ImmutableSet<OWLClass>)((ImmutableSet)this.getDomains().stream().map(OWLClassData::getEntity).collect(ImmutableSet.toImmutableSet())), (ImmutableSet<OWLClass>)((ImmutableSet)this.getRanges().stream().map(OWLClassData::getEntity).collect(ImmutableSet.toImmutableSet())), (ImmutableSet<OWLObjectProperty>)((ImmutableSet)this.getInverseProperties().stream().map(OWLObjectPropertyData::getEntity).collect(ImmutableSet.toImmutableSet())));
    }
}

