/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.frame;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableSet;
import edu.stanford.protege.webprotege.frame.AutoValue_PlainAnnotationPropertyFrame;
import edu.stanford.protege.webprotege.frame.PlainEntityFrame;
import edu.stanford.protege.webprotege.frame.PlainPropertyAnnotationValue;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;

@JsonTypeName(value="AnnotationPropertyFrame")
@AutoValue
public abstract class PlainAnnotationPropertyFrame
extends PlainEntityFrame {
    public static final String ANNOTATION_PROPERTY_FRAME = "AnnotationPropertyFrame";
    private static final String DOMAINS = "domains";
    private static final String RANGES = "ranges";

    @JsonCreator
    @Nonnull
    public static PlainAnnotationPropertyFrame get(@Nonnull @JsonProperty(value="subject") OWLAnnotationProperty subject, @Nonnull @JsonProperty(value="propertyValues") ImmutableSet<PlainPropertyAnnotationValue> annotations, @Nonnull @JsonProperty(value="domains") ImmutableSet<IRI> domains, @Nonnull @JsonProperty(value="ranges") ImmutableSet<IRI> ranges) {
        return new AutoValue_PlainAnnotationPropertyFrame(subject, annotations, domains, ranges);
    }

    public static PlainAnnotationPropertyFrame empty(OWLAnnotationProperty property) {
        return PlainAnnotationPropertyFrame.get(property, (ImmutableSet<PlainPropertyAnnotationValue>)ImmutableSet.of(), (ImmutableSet<IRI>)ImmutableSet.of(), (ImmutableSet<IRI>)ImmutableSet.of());
    }

    @Override
    @Nonnull
    public abstract OWLAnnotationProperty getSubject();

    @Nonnull
    public abstract ImmutableSet<PlainPropertyAnnotationValue> getPropertyValues();

    @JsonProperty(value="domains")
    @Nonnull
    public abstract ImmutableSet<IRI> getDomains();

    @JsonProperty(value="ranges")
    @Nonnull
    public abstract ImmutableSet<IRI> getRanges();

    @Override
    @Nonnull
    public PlainAnnotationPropertyFrame toPlainFrame() {
        return this;
    }
}

